package com.bcxin.identify.components.ringbuffers.datas;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter(AccessLevel.PRIVATE)
public class LoggingCacheObject {
    private final String businessType;
    private final String requestStatus;
    private final String request;
    private final String response;

    public LoggingCacheObject(String businessType, String requestStatus, String request, String response) {
        this.businessType = businessType;
        this.requestStatus = requestStatus;
        this.request = request;
        this.response = response;
    }

    public static LoggingCacheObject create(String businessType, String requestStatus, String request, String response) {
        LoggingCacheObject cacheObject = new LoggingCacheObject(
                businessType,
                requestStatus,
                request, response
        );

        return cacheObject;
    }
}
