package com.bcxin.identify.business.domain.ysp;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 视频邀请人员信息 </b>
 * @author ZXF
 * @create 2020/06/19 0019 16:27
 * @version
 * @注意事项 </b>
 */
@Data
@TableName("per_video_room")
public class PerVideoRoom extends Model<PerVideoRoom> {

	private static final long serialVersionUID = 1L;

	/**
	 * 邀请ID
	 */
	@TableId(type = IdType.ID_WORKER)
	private Long perVideoRoomId;

	/**
	 * 记录ID
	 */
	private Long comVideoRoomId;

	/**
	 * 人员cid
	 */
	private String cid;

	/**
	 * 人员useid
	 */
	private String useid;

	/**
	 * 参会状态：0.拒绝；1.接受；2.录制；9.未响应 ，默认（未响应）
	 */
	private String attendExpoStatus;

	/**
	 * 视频开始录制时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date startTime;

	/**
	 * 视频结束录制时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date endTime;

	/**
	 * 视频流ID（腾讯）
	 */
	private String streamId;

	/**
	 * 视频文件ID（腾讯）
	 */
	private String fileId;

	/**
	 * 视频地址
	 */
	private String videoPath;

	/**
	 * 是否是发起人
	 */
	private int isSponsor;


	/**
	 * 用户id
	 */
	private String personId;


	/**
	 * 用户id
	 */
	private String domainId;
	/**
	 * 创建时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date createOn;

	/**
	 * 修改时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date updateOn;

	@Override
	protected Serializable pkVal() {
		return this.perVideoRoomId;
	}
}
