package com.bcxin.identify.api.tencent.dto.im;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.bcxin.identify.util.DES3;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.servlet.http.HttpServletRequest;

/**
 * <b> Im返回结果信息类 </b>
 * @author ZXF
 * @create 2019/06/21 0021 10:06
 * @version
 * @注意事项 </b>
 */
public class ImResult {

	private String api;// 接口名称
	private String v;// 版本号
	private String ActionStatus;// 请求处理的结果，OK 表示处理成功，FAIL 表示失败
	private String ErrorCode;// 错误码，0表示成功，非0表示失败
	private String ErrorInfo;// 错误信息
	private Object GroupInfo;// 返回结果为群组信息数组，内容包括群基础资料字段、群成员资料字段、群组维度自定义字段和群成员维度自定义字段
	private String GroupId;// 群组Id

	/**
	 * 成功
	 */
	public static final String OK = "OK";

	/**
	 * 服务端内部错误
	 */
	public static final String FAIL = "FAIL";

	public ImResult(){}

	public ImResult(String ActionStatus, String ErrorCode, String ErrorInfo, Object GroupInfo, String GroupId) {
		super();
		this.ActionStatus = ActionStatus;
		this.ErrorCode = ErrorCode;
		this.ErrorInfo = ErrorInfo;
		this.GroupInfo = GroupInfo;
		this.GroupId = GroupId;
	}

	/**
	 * 服务端内部错误
	 */
	public static final String ERROR = "-1";
	/**
	 * 业务异常错误
	 */
	public static final String BUSINESS_ERROR = "-2";

	/**
	 * 失败消息
	 */
	public static final String ERROR_MSG = "操作失败:";

	/**
	 * 错误信息返回
	 *
	 * @param errorMsg
	 * @return
	 */
	public static ImResult fail(String errorMsg) {
		return new ImResult(ImResult.FAIL, ImResult.ERROR, (errorMsg == null || errorMsg.equals("")) ? ImResult.ERROR_MSG : errorMsg,
				null, null);
	}

	public ImResult setBack(HttpServletRequest request) {
		this.setApi(request.getParameter("api"));
		this.setV(request.getParameter("v"));
		return this;
	}

	public String getActionStatus() {
		return ActionStatus;
	}

	public void setActionStatus(String actionStatus) {
		ActionStatus = actionStatus;
	}

	public String getErrorCode() {
		return ErrorCode;
	}

	public void setErrorCode(String errorCode) {
		ErrorCode = errorCode;
	}

	public String getErrorInfo() {
		return ErrorInfo;
	}

	public void setErrorInfo(String errorInfo) {
		ErrorInfo = errorInfo;
	}

	public Object getGroupInfo() {
		return GroupInfo;
	}

	public void setGroupInfo(Object groupInfo) {
		GroupInfo = groupInfo;
	}

	public String getApi() {
		return api;
	}

	public void setApi(String api) {
		this.api = api;
	}

	public String getV() {
		return v;
	}

	public void setV(String v) {
		this.v = v;
	}

	public String getGroupId() {
		return GroupId;
	}

	public void setGroupId(String groupId) {
		GroupId = groupId;
	}

	/**
	 * APP数据加密工具
	 **/
	@JsonIgnore
	public static String getDecodeData(String data) {
		try {
			return data == null ? null : DES3.decode(data.toString());
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	@JsonIgnore
	public static <T> T getDecodeData(String data, Class<T> clazz) {
		return JSON.parseObject(getDecodeData(data), clazz);
	}

	public static Object setEncodeData(Object data) {
		try {
			SimplePropertyPreFilter filter = new SimplePropertyPreFilter();
			filter.getExcludes().add("ActionStatus");
			filter.getExcludes().add("ErrorCode");
			filter.getExcludes().add("ErrorInfo");
			filter.getExcludes().add("GroupInfo");
			filter.getExcludes().add("GroupId");
			filter.getExcludes().add("api");
			filter.getExcludes().add("v");
//			JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
			return DES3.encode(JSON.toJSONString(data));
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
}
