package com.bcxin.identify.api.common.controller;

import cn.hutool.core.util.StrUtil;
import com.bcxin.identify.business.service.AppVersionService;
import com.bcxin.identify.business.service.LogBusinessrequestService;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.common.Const;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * <b> 外部调用第三方接口可将过程数据通过该控制器进行留存更新 </b>
 * @author ZXF
 * @create 2022/02/28 0028 16:33
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/identify/api/logb")
@Slf4j
public class LogBusinessController {

    @Resource
    private LogBusinessrequestService logBusinessrequestService;

    @PostMapping(value = "/save")
    @ResponseBody
    public Result save(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        String requestMessage = request.getParameter("requestMessage");
        String responseMessage = request.getParameter("responseMessage");
        Map<String,String> params = Maps.newHashMap();
        params.put("businessType",businessType);
        params.put("requestMessage",requestMessage);
        params.put("responseMessage",responseMessage);

        if (
                StrUtil.isEmpty(params.get("businessType"))||
                StrUtil.isEmpty(params.get("requestMessage"))||
                StrUtil.isEmpty(params.get("responseMessage"))
        ) {
            return Result.fail("参数不完整");
        }
        logBusinessrequestService.save(params.get("businessType"), Const.Y, params.get("requestMessage"), params.get("responseMessage"));
        return Result.success("更新成功");
    }

}
