package com.bcxin.identify.api.baidu.service;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.identify.business.service.LogBusinessrequestService;
import com.bcxin.identify.components.ringbuffers.RingBufferProducer;
import com.bcxin.identify.components.ringbuffers.datas.LoggingCacheObject;
import com.bcxin.identify.startup.CacheService;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.baidu.ocr.IdcardAI;
import com.bcxin.identify.util.baidu.v3.FaceMatch;
import com.bcxin.identify.util.common.Const;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * <b> 百度认证相关接口业务处理 </b>
 * @author ZXF
 * @create 2021/01/28 0028 16:45
 * @version
 * @注意事项 </b>
 */
@Service
public class BaiduVerifaceService {
    @Resource
    private CacheService cacheService;
    @Resource
    private RingBufferProducer ringBufferProducer;

    /**
     * <b> 人脸比对 </b>
     * @author ZXF
     * @create 2021/01/29 0029 14:07
     * @version
     * @注意事项 </b>
     */
    public Result matchFace(Map<String,String> params) {
        int vtp = 80;
        try {
            vtp = Integer.parseInt(params.get("vtp"));
        } catch (Exception ex) {

        }
        String tokenBD = cacheService.getBaiduV3AccessToken(params.get("appointChannel"));
        if (tokenBD == null) {
            return Result.fail("百度人脸比对token获取失败!");
        }
        Map<String, String> matchResult = FaceMatch.matchResult(tokenBD,
                params.get("oneImg"), params.get("twoImg"), vtp, params.get("bizFaceMode"));

        ringBufferProducer.publish(LoggingCacheObject.create(
                "MATCH-FACE" + params.get("version"), Const.N, params.toString(),
                matchResult.toString()
        ));

        matchResult.put("v-3", "1.6");

        return Result.success(Result.SUCCESS_QUERY_MSG, matchResult);
    }

    /**
     * <b> 人脸比对 </b>
     * @author ZXF
     * @create 2021/01/29 0029 14:07
     * @version
     * @注意事项 </b>
     */
    public Result parsingIdcard (Map<String,Object> params){
        String tokenBD = cacheService.getBaiduORCAccessToken();
        if (tokenBD == null) {
            return Result.fail("百度身份证识别token获取失败!");
        }
        Result result = IdcardAI.idcard(tokenBD,String.valueOf(params.get("imgPath")),String.valueOf(params.get("side")));
        ringBufferProducer.publish(LoggingCacheObject.create(
                "PARSING-IDCARD", Const.N, params.toString(), JSONObject.toJSONString(result)
        ));

        return result;
    }

    public String getBaiduKTAccessToken (){
        return cacheService.getBaiduKTAccessToken();
    }
}
