package com.bcxin.fdd.strategy;

import com.alibaba.fastjson.JSONObject;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.stratey.JsonStrategy;

import java.lang.reflect.ParameterizedType;
import java.util.List;

public class FastJsonStrategy implements JsonStrategy {

    public FastJsonStrategy() {
    }

    public String toJson(Object object) throws ApiException {
        return JSONObject.toJSONString(object);
    }

    public <T> T toJavaBean(String json, ParameterizedType parameterizedType) throws ApiException {
        return JSONObject.parseObject(json, parameterizedType);
    }

    public <T> T toJavaBean(String json, Class<T> clzz) throws ApiException {
        return JSONObject.parseObject(json, clzz);
    }

    public <T> List<T> toList(String json, Class<T> clzz) throws ApiException {
        return JSONObject.parseArray(json, clzz);
    }

}
