package com.bcxin.fdd.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.fdd.configs.FddConfig;
import com.bcxin.fdd.dao.mapper.BfOrganizationMapper;
import com.bcxin.fdd.entity.BfOrganizationEntity;
import com.bcxin.fdd.strategy.FastJsonStrategy;
import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.config.HttpConfig;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.client.ServiceClient;
import com.fasc.open.api.v5_1.res.service.AccessTokenRes;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * description：百川信法大大api 服务实现类
 * author：linchunpeng
 * date：2024/7/11
 */
@Slf4j
@Component
public class FddApiUtilService extends ServiceImpl<BfOrganizationMapper, BfOrganizationEntity> {

    @Autowired
    private FddConfig fddConfig;
    @Autowired
    private RedisService redisService;

    private static final String ACCESS_TOKEN_REDIS_KEY = "ACCESS_TOKEN_REDIS_KEY";

    /**
     * 获取accessToken
     */
    public String getAccessToken(OpenApiClient openApiClient) {
        Object object = redisService.getCacheObject(ACCESS_TOKEN_REDIS_KEY);
        if (object != null) {
            return object.toString();
        }
        try {
            // 初始化业务客户端
            ServiceClient serviceClient = new ServiceClient(openApiClient);
            // 获取accessToken
            BaseRes<AccessTokenRes> res = serviceClient.getAccessToken();
            log.info("获取accessToken：{}", JSONObject.toJSONString(res));
            String accessToken = res.getData().getAccessToken();
            redisService.setCacheObject(ACCESS_TOKEN_REDIS_KEY, accessToken, 60L, TimeUnit.MINUTES);
            return accessToken;
        } catch (Exception e) {
            e.printStackTrace();
            log.error("获取accessToken异常，{}", e.getMessage(), e);
        }
        return null;
    }

    /**
     * 获取api客户端
     */
    public OpenApiClient getOpenApiClient() {
        //法大大分配的appId
        String appId = fddConfig.getAppid();
        //法大大分配的appId对应的秘钥
        String appSecret = fddConfig.getAppSecret();
        //API请求地址
        String serverUrl = fddConfig.getServerUrl();
        // 初始化客户端
        OpenApiClient openApiClient = new OpenApiClient(appId, appSecret, serverUrl);
        // http超时配置设置， 默认不设置超时时间
        // 如果不设置超时时间 该设置可忽略
        HttpConfig httpConfig = new HttpConfig();
        httpConfig.setConnectTimeout(1000000);
        httpConfig.setReadTimeout(1000000);
        openApiClient.setHttpConfig(httpConfig);
        // Json序列化策率，默认使用Jackson，如果要使用其他如FastJson,Gson等实现JsonStrategy接口即可
        openApiClient.setJsonStrategy(new FastJsonStrategy());
        return openApiClient;
    }

}