package com.bcxin.fdd.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * description：百川信法大大组织表
 * author：linchunpeng
 * date：2024/7/11
 */
@Data
@TableName("bf_organization")
public class BfOrganizationEntity implements Serializable {

   private static final long serialVersionUID = 1L;

   //主键id
   @TableId(value = "id")
   private Long id;

   //组织名称
   private String name;

   //组织统一社会信用代码
   private String code;

   //法人
   private String legalPersonName;

   //百川信组织id
   private String bcxOrganizationId;

   //百川信组织管理员id
   private String bcxOrganizationAdminId;

   //企业授权状态，1已授权；0未授权
   private Integer authStatus;

   //法大大主体id
   private String fddEntityId;

   //法大大clientCorpId
   private String fddClientCorpId;

   //法大大openCorpId
   private String fddOpenCorpId;

   //法大大管理员用户id
   private String fddAdminUserId;

   //法大大管理员成员id
   private String fddAdminMemberId;

   //开通状态，0-未开通，1-已开通，2-已禁用
   private Integer status;

   //备注
   private String remark;

   //创建时间
   @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
   private Date createTime;

   //更新时间
   @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
   private Date updateTime;

}