package com.bcxin.fdd.common.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;

/**
 * description: 文件工具类
 * author: linchunpeng
 * date:  2023-04-18 15:15
 */
@Slf4j
public class FileUtils {

    /**
     * description: 根据url下载文件
     * author: linchunpeng
     * date:  2023-04-18 15:15
     */
    public static String downloadByUrl(String urlStr, String savePath) {
        InputStream inputStream = null;
        FileOutputStream fos = null;
        try {
            String urlZh = URLDecoder.decode(urlStr, "utf-8");
            String fileName = null;
            if (urlZh.contains(";filename=\"")) {
                fileName = urlZh.substring(urlZh.indexOf(";filename=\"") + 11);
                if (fileName.contains("\"&")) {
                    fileName = fileName.substring(0, fileName.indexOf("\"&"));
                }
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            //设置超时间为30秒
            conn.setConnectTimeout(30 * 1000);
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            //得到输入流
            inputStream = conn.getInputStream();
            //获取自己数组
            byte[] getData = readInputStream(inputStream);
            //文件保存位置
            if (!FileUtil.exist(savePath)) {
                log.info("目录：{}，不存在，创建", savePath);
                FileUtil.mkdir(savePath);
                if (FileUtil.exist(savePath)) {
                    log.info("创建成功");
                } else {
                    log.info("创建失败");
                }
            }

            //获取文件名及后缀
            if (StringUtils.isBlank(fileName)) {
                String headerField = conn.getHeaderField("Content-Disposition");
                String[] split = headerField.split("\"");
                fileName = URLDecoder.decode(split[1], "utf-8");
            }
            String fileSavePath = savePath + File.separator + fileName;
            //开始写入
            File file = new File(fileSavePath);
            fos = new FileOutputStream(file);
            fos.write(getData);
            log.info("文件: {}，下载成功", urlStr);
            return fileSavePath;
        } catch (Exception e) {
            log.error("文件：{}，下载异常", urlStr, e);
        } finally {
            try {
                if (inputStream != null) inputStream.close();
                if (fos != null) fos.close();
            } catch (Exception e) {
                log.error("文件：{}，关闭流异常", urlStr, e);
            }
        }
        return "fail";
    }

    /**
     * description: 从输入流中获取字节数组
     * author: linchunpeng
     * date:  2023-04-18 15:33
     */
    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[4 * 1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

//    public static void main(String[] args) {
//        downloadByUrl("https://pdf-test-os1.fadada.com/5a5a0e349e084bd9a6c0c212c6eac3fa?sign=q-sign-algorithm%3Dsha1%26q-ak%3DAKIDUmoZ3GI3XkgKhmb9QP9dqlPmshFXXGit%26q-sign-time%3D1723791506%3B1723795106%26q-key-time%3D1723791506%3B1723795106%26q-header-list%3Dhost%26q-url-param-list%3Dresponse-cache-control%3Bresponse-content-disposition%3Bresponse-content-type%3Bresponse-expires%26q-signature%3D72b535c9c7a34bef53b870a7b0e4f4a93a41c8da&response-cache-control=no-store%2C%20no-cache%2C%20must-revalidate&response-content-disposition=inline%3Bfilename%3D%22%E6%B5%8B%E8%AF%95%E5%90%88%E5%90%8C.pdf%22&response-expires=0&response-content-type=application%2Fpdf", "/Users/linchunpeng/Downloads");
//    }
}
