package com.bcxin.fdd.common.emus;

/**
 * 任务类型，1劳动合同；2其他合同
 */
public enum TaskTypeEnum {

    //1劳动合同
    LABOR_CONTRACT(1, "劳动合同"),
    //2其他合同
    OTHER_CONTRACT(2, "其他合同");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    TaskTypeEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
