package com.bcxin.fdd.common.emus;

/**
 * 任务状态，1发起；2确认提交；3撤销；4过期；5作废；6签署中；10完成
 */
public enum TaskStatusEnum {

    //1发起
    START(1, "发起"),
    //2确认提交
    SUBMIT(2, "确认提交"),
    //3撤销
    CANCEL(3, "撤销"),
    //4过期
    EXPIRED(4, "过期"),
    //5作废
    ABANDON(5, "作废"),
    //6签署中
    SIGNING(6, "签署中"),
    //7拒签
    REJECTED(7, "拒签"),
    //10完成
    COMPLETE(10, "完成");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    TaskStatusEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
