	//初始化日历表
	function initCalendar(){
		var date = new Date();
		var d = date.getDate();
		var m = date.getMonth();
		var y = date.getFullYear();
		$('#calendar').fullCalendar({
			header: {
				left: 'prev,next today',
				center: 'title',
				right: 'month,agendaWeek,agendaDay'
			},
			firstDay:0,
			editable: true,
			selectable:true,
			timeFormat: 'H:mm',
			axisFormat: 'H:mm',
			weekMode:"liquid",
	        select:function( startDate, endDate, allDay, jsEvent, view ){
	        	var format1 = "yyyy-MM-dd HH:mm";
	        	addPlan($.fullCalendar.formatDate(startDate,format1),$.fullCalendar.formatDate(endDate,format1),this);
	        },
	        events:function( start, end, callback) {
	        	var beginTime = $.fullCalendar.formatDate(start,'yyyy-MM-dd 00:00');
	        	var endTime = $.fullCalendar.formatDate(end,'yyyy-MM-dd 24:00');
	        	
	        	$.ajax({			
	    			type : 'POST',
	    			url : baseUrl + "/wechat/plan/getSurveyPlan.json",
	    			data : {
	    				"beginTime":beginTime,
	    				"endTime":endTime
	    			},
	    			dataType : "json",
	    			async :false,
	    			success : function(data) {
	    				var eventList = [];
	                    $(data.events).each(function() {
	                    	var id=$(this).attr('id');
	                    	var allDay=$(this).attr('allDay');
	                    	var start=$(this).attr('start');
	                    	var end=$(this).attr('end');
	                    	var taskStatus = $(this).attr('taskStatus');
	                    	if(taskStatus =="NON" )
		                    	eventList.push({
		                    		id:id,
		                    		allDay:allDay,
		                            title: $(this).attr('title'),
		                            start: start,
		                            end: end,
		                            url: 'javascript:updatePlan("'+id+'",this);'
		                        });	
	                    	else
	                    		eventList.push({
		                    		id:id,
		                    		allDay:allDay,
		                            title: $(this).attr('title'),
		                            start: start,
		                            end: end
		                        });	
	                    });
	                    callback(eventList);
	    			}
	    		});
	        },
//	        eventDrop: function(event,dayDelta,minuteDelta,allDay,revertFunc) { //拖拽结束事件
//	        	var format = "yyyy-MM-dd HH:mm";	        	
//// 	            layer.msg("event:"+JSON.stringify(event));
//	            $.ajax({			
//	    			type : 'POST',
//	    			url : baseUrl + "/wechat/plan/updateSurveyPlan.json",
//	    			data : {
//	    				"oid":event.id,
//	    				"allDay":event.allDay,
//	    				"beginTime":$.fullCalendar.formatDate(event.start,format),
//	    				"endTime":$.fullCalendar.formatDate(event.end,format)
//	    			},
//	    			dataType : "json",
//	    			async :false,
//	    			success : function(data) {
//	    				layer.msg(data.message);
//	    				if(data.statusCode == "200")
//	    					updateEvent();
//	    			}
//	    		});
//	        } 
		});
	}
	

	function addPlan(startDate, endDate,obj){
		startDate = startDate.replace(' ','—');
		endDate = endDate.replace(' ','—');
		var surveyTaskId = $("#surveyTaskId").val();
		$("body").addClass("unoverflow");
        $("#modal").remove();
    	$(obj).d_modal({
            title: '新增计划',
            cssclass:'modal-blue modal-mid',
            content: "loading....",
            cache:false,
            remote: baseUrl + '/wechat/plan/addPlan/init?taskId='+surveyTaskId+'&start='+startDate+'&end='+endDate
        });
	}
	
	function updatePlan(planId,obj){
		$("body").addClass("unoverflow");

        $("#modal").remove();
		$(obj).d_modal({
            title: '修改计划',
            cssclass:'modal-blue modal-mid',
            content: "loading....",
            cache:false,
            remote: baseUrl + "/wechat/plan/editPlan/init/"+planId
        });
	}
	
	function deletePlan(planId){
		layer.confirm("确定要删除此勘查计划吗？", {
			  title:"删除计划",
			  btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({			
					type : 'POST',
					url : baseUrl + "/wechat/plan/deleteSurveyPlan.json",
					data :{"planId":planId},
					dataType : "json",
					// async :false,
					success : function(data) {
						layer.close(loadIndex);
						var message = data.message;
						if(data.statusCode =="200"){
							layer.alert(message,{
								yes :function(){
									window.location.reload();//刷新当前页面.
								},
								cancel :function(){
									window.location.reload();//刷新当前页面.
								}
							});
						}else if(message != "")
							layer.msg(message);
					},error: function(){
						layer.close(loadIndex);
						layer.msg('系统发生未知错误，请联系管理员确认');
					}
				});
			}, function(){
			});
	}

	function updateEvent(){
        $('#calendar').fullCalendar('refetchEvents'); 
	}
	
	function editPlanSuccess(message){
		layer.closeAll();
		var pageType = $("#pageType").val();
		layer.alert(message,{
			yes :function(){
				if(pageType == "calendar"){
					updateEvent();//更新日程表
					closeModal();
					layer.closeAll();
				}
				else{
					window.location.reload();//刷新当前页面.
				}
			},
			cancel :function(){
				if(pageType == "calendar"){
					updateEvent();//更新日程表
					closeModal();
					layer.closeAll();
				}
				else
					parent.window.location.reload();//刷新当前页面.
			}
		});
	}