package com.bcxin.survey.filter;

import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.security.UserFacet;
import com.bcxin.survey.utils.DictConst;
import com.bcxin.survey.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;

public class UrlAuthenticationSuccessHandler extends SimpleUrlAuthenticationSuccessHandler {

	private SecurityRedirect	redirect;
	
	private RequestCache		requestCache;

	@Autowired
	private UserService userService;
	
	public UrlAuthenticationSuccessHandler() {
		this.requestCache = new HttpSessionRequestCache();
	}

	@Override
	public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response,
			Authentication authentication) throws IOException, ServletException {

		HttpSession session = request.getSession();
        String targetUrl = (String) session.getAttribute("targetUrl");// 获取登录访问前的URL
        if(StringUtil.isEmpty(targetUrl)){
        	SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        	if (savedRequest == null) {
    			User user = null;
    			try {
    				user = ((UserFacet) authentication.getPrincipal()).subject();
    			} catch (Exception e) {
    			}

    			if (response.isCommitted()) {
    				logger.debug("Response has already been committed. Unable to redirect to " + redirect.direct());
    				return;
    			}

    			if (user.getUserType().equals(DictConst.USERTYPE_DSFFWJGYH_TKQT)) {
    				// 根据角色分配地址
    				getRedirectStrategy().sendRedirect(request, response, "/wechat/index");
    				clearAuthenticationAttributes(request);
    				return;
    			} else {
    				getRedirectStrategy().sendRedirect(request, response, redirect.direct());
    				clearAuthenticationAttributes(request);
    				return;
    			}
    		}else{
    			targetUrl = savedRequest.getRedirectUrl();// 获取登录访问前的URL
    		}
        }else{
        	session.removeAttribute("targetUrl");
        }
        if(StringUtil.isNotEmpty(targetUrl)){
			System.out.println("登录成功，登录前访问地址："+targetUrl);
			if(targetUrl.contains("/manage/")) {
				targetUrl = "/manage/index";
			}else if(targetUrl.contains("/wechat/") && targetUrl.contains("init")){
				
			}else if(targetUrl.contains("wechat/task")) {
				targetUrl = "/wechat/task/taskList/init";
			}else if(targetUrl.contains("wechat/plan")) {
				targetUrl = "/wechat/plan/surveyPlan/init";
			}else if(targetUrl.contains("wechat/question")) {
				targetUrl = "/wechat/question/init";
			}else if(targetUrl.contains("wechat/survey")) {
				targetUrl = "/wechat/survey/siteSurvey/init";
			}
			
			getRedirectStrategy().sendRedirect( request, response, targetUrl);
			clearAuthenticationAttributes(request);
			return;
		}else {
			getRedirectStrategy().sendRedirect(request, response, redirect.direct());
			clearAuthenticationAttributes(request);
			return;
		}
		
	}

	public SecurityRedirect getRedirect() {
		return redirect;
	}

	public void setRedirect(SecurityRedirect redirect) {
		this.redirect = redirect;
	}
}
