package com.bcxin.survey.domain.report;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.ProductCode;
import com.bcxin.survey.enums.report.AcceptStatus;
import com.bcxin.survey.enums.report.TaskStatus;
import com.bcxin.survey.utils.StringUtil;
import lombok.Data;
import org.hibernate.annotations.Proxy;

import javax.persistence.*;
import java.util.Collection;
import java.util.Date;

/**
 * 流程父类
 * 
 * @author luopeng
 *
 */
@Entity
@Data
@Table(name = "RISK_TASK")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = Task.class)
public class Task extends BaseBean{

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;// 报告
	
	private String name;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "assgin_id")
	private User assgin;

	/**
	 * 踏勘专家
	 */
	@JoinColumn(name = "expert_id")
	private String expert_id;

//	private AcceptStatus acceptStatus; //任务接收状态
//
//	private TaskStatus taskStatus; //任务处理状态

	//任务接收状态
	private String acceptStatus;
	//任务处理状态
	private String taskStatus;

	private String taskType;

	@Temporal(TemporalType.TIMESTAMP)
	private Date acceptDate; //任务接收时间
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date finishDate;//任务结束时间
	
	private String period; //任务处理时间


	@Column(name = "tk_config")
	private String tkConfig;//踏勘阶级  (TK01,TK02,TK03)（产品类型：初阶踏勘、进阶踏勘、高阶踏勘）

	@Column(name = "zj_config")
	private String zjConfig;//专家类型 (ZJ01,ZJ02,ZJ03)（产品类型：现场专家、远程专家、咨询专家）


	public String getMaxTKConfig(String tkConfig){
		if (tkConfig.equals(ProductCode.SURVEY_LEVEL_3)){
			return tkConfig;
		}else if (tkConfig.equals(ProductCode.SURVEY_LEVEL_2)&&this.tkConfig.equals(ProductCode.SURVEY_LEVEL_1)){
			return tkConfig;
		}else {
			return this.tkConfig;
		}
	}

	public int getTKConfigLeve() {
		if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_3)){
			return 3;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_2)){
			return 2;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_1)){
			return 1;
		}else{
			return 0;
		}
	}

	public String getTKConfigStr() {
		if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_3)){
			return "FIRST,SECOND,THIRD";
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_2)){
			return "FIRST,SECOND";
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_1)){
			return "FIRST";
		}else{
			return "";
		}
	}

	public boolean isSurveyTask(String productCode) {
		if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_3)){
			return false;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_2)&&!productCode.equals(ProductCode.SURVEY_LEVEL_3)){
			return false;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_1)&&productCode.equals(ProductCode.SURVEY_LEVEL_1)){
			return false;
		}else {
			return true;
		}
	}

	public boolean isExpertType(String productCode) {
		if (this.zjConfig.indexOf(productCode)>=0){
			return false;
		}else {
			return true;
		}
	}

	public Collection<String> getTKType() {
		//17 专家现场勘查，23 专家远程勘查 ，24 专家远程咨询
		// (ZJ01,ZJ02,ZJ03)（产品类型：现场专家、远程专家、咨询专家）
		Collection<String> tkType = null;
		if(StringUtil.isNotEmpty(this.tkConfig)){
			if (this.tkConfig.indexOf(ProductCode.EXPERT_TYPE_3)>=0){
				tkType.add(ProductCode.T_K_TYPE_3);
			}
			if (this.tkConfig.indexOf(ProductCode.EXPERT_TYPE_2)>=0){
				tkType.add(ProductCode.T_K_TYPE_2);
			}
			if (this.tkConfig.indexOf(ProductCode.EXPERT_TYPE_1)>=0){
				tkType.add(ProductCode.T_K_TYPE_1);
			}
		}
		return tkType;
	}
}
