package com.bcxin.survey.controller;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import com.bcxin.survey.base.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.survey.domain.data.Region;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.utils.CollectionUtil;
import com.bcxin.survey.utils.SysRegionUtil;


@Controller
@RequestMapping("/public")
public class PublicController extends BaseController {

	
	@Autowired
	private UserService userService;
	
	@Autowired
	private SysRegionUtil sysRegionUtil;
	
	private Logger log = LoggerFactory.getLogger(PublicController.class);
	
	@RequestMapping("/heartBeat")
	public String heartBeat() {
		User user = userService.getCurrentUser();
		if ( user == null ) {
			return "redirect:/user/login/init";
		}
		log.info("用户[{}]正在进行心跳检测",user);
		return "";
	} 

	/**
     * 获取城市
     * @return
     */
    @RequestMapping(value = "/provinceList")
    public @ResponseBody Collection<Region> provinceList(){
        return sysRegionUtil.provinceMap();
    }

    /**
     * 获取地区
     * 支持根据省查市，根据市查区县
     * @return
     */
    @RequestMapping(value = "/getRegionByParent")
    public @ResponseBody Collection<Region> regionList(HttpServletRequest request){
        String parentId = request.getParameter("parentId");
        Collection<Region> regionList = sysRegionUtil.cityMap().get(parentId);
        if (CollectionUtil.isEmpty(regionList)) {
            regionList = sysRegionUtil.areaMap().get(parentId);
        }
        return regionList;
    }
}
