package com.bcxin.survey.utils;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatorUtil {

	/**
	 * 校验email
	 * 
	 * @param email
	 * @return
	 */
	public static boolean validateEmail(String email) {
		if (email == null) {
			return false;
		}

		// 不能有连续的.
		if (email.indexOf("..") != -1) {
			return false;
		}

		// 必须带有@
		int atCharacter = email.indexOf("@");
		if (atCharacter == -1) {
			return false;
		}

		// 最后一个.必须在@之后,且不能连续出现
		if (atCharacter > email.lastIndexOf('.')
				|| atCharacter + 1 == email.lastIndexOf('.')) {
			return false;
		}

		// 不能以.,@结束和开始
		if (email.endsWith(".") || email.endsWith("@") || email.startsWith(".")
				|| email.startsWith("@")) {
			return false;
		}

		return true;
	}

	/**
	 * 校验电子邮箱
	 * @param email
	 * @return boolean
	 */
	public static boolean checkIsValidEmail(String email) {
		Pattern emailPattern = Pattern.compile("^([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,3}$");
		Matcher mathcher = emailPattern.matcher(email);
		return mathcher.matches();
	}
	
	/**
	 * 手机号验证
	 * 
	 * @param str
	 * @return 验证通过返回true
	 */
	public static boolean validateMobile(String mobile) {
		Pattern p = null;
		Matcher m = null;
		boolean b = false;
		p = Pattern.compile("^[1][3,4,5,8][0-9]{9}$"); // 验证手机号
		m = p.matcher(mobile);
		b = m.matches();
		return b;
	}

	/**
	 *正则表达式交易通用类 
	 * @param message 需要校验的信息
	 * @param regex 正则表达式
	 * @return 校验结果
	 */
	protected boolean validateRegex(String message, String regex) {
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(message);
		return matcher.matches();
	}
	
	public static String codeString(InputStream is) throws Exception{  
	    int p = (is.read() << 8) + is.read();  
	    String code = null;  
	      
	    switch (p) {  
	        case 0xefbb:  
	            code = "UTF-8";  
	            break;  
	        case 0xfffe:  
	            code = "Unicode";  
	            break;  
	        case 0xfeff:  
	            code = "UTF-16BE";  
	            break;  
	        default:  
	            code = "GBK";  
	    }  
	      
	    return code;  
	}
	
	
	/**
     * 验证邮箱地址是否正确
     * 
     * @param email
     * @return
     */
	public static boolean checkEmail(String email) {
        boolean flag = false;
        try {
            String check = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            flag = matcher.matches();
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    
    /**
     * 验证手机号码
     * 
     * @param mobiles
     * @return [0-9]{5,9}
     */
	public static boolean validatePhone(String mobile) {
        boolean flag = false;
        try {
            Pattern regex = Pattern.compile("^0?(13[0-9]|15[0-9]|18[0-9]|14[57]17[0678])[0-9]{8}$");
            Matcher matcher = regex.matcher(mobile);
            flag = matcher.matches();
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }
	
	/**
	 * 判断是否为数字
	 * @param trim
	 * */
	public static boolean isNumeric(String trim) {
		if(trim == null || "".equals(trim)) {
			return false;
		}
		Pattern pattern = Pattern.compile("[0-9]*");
		
		return pattern.matcher(trim).matches();
	}
	
	public static boolean isFloat(String trim){
		return trim.matches("^[0-9]+([.]{0,1}[0-9]+){0,1}$");
	}
}
