package com.bcxin.survey.enums.report;

/**
 * 踏勘问卷任务状态
 */
public enum QuestionStatusEnum {

    NON("NON","未完成"),
    CONTINUE("CONTINUE","进行中"),
    COMPLETE("COMPLETE","已完成");

    private String key;
    private String alias;

    QuestionStatusEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public String getName(){return this.alias;}

    public static String getAlias(String key){
        for(QuestionStatusEnum e : QuestionStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
