package com.bcxin.survey.dto;

import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.Survey_Info;
import com.bcxin.survey.domain.survey.Survey_Photo;
import com.bcxin.survey.utils.StringUtil;
import lombok.Data;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.io.Serializable;
import java.util.List;

/**
 * @author hzp
 * 踏勘动态看板数据结构
 * 数据结构属性与对应的模板key相对应
 */
@Data
public class DynamicSurveyPanel implements Serializable {

    /**
     * 踏勘问卷id
     */
    private String questionnaireId;

    private String taskId;
    /**
     * 操作人
     */
    private String operateId;
    private String operateName;
    private String userName;

    /**
     * 活动
     */
    private String activityId;
    private String activityName;

    /**
     * 踏勘人员
     */
    private String tkUserId;
    private String tkUserName;

    /**
     * 踏勘专家
     */
    private String tkzjUserList;

    /**
     * 踏勘场馆
     */
    private String tkVenue;

    /**
     * 踏勘时间
     */
    private String tkTime;

    /**
     * 踏勘阶段
     */
    private String step;

    /**
     * 踏勘报告
     */
    private String surveyReport;

    /**
     * 踏勘整改意见
     */
    private JSONArray reformList;


    /**
     * 踏勘整改回复
     */
    private JSONArray reformSuggest;


    public DynamicSurveyPanel(User operateUser, Activity activity,String step,String surveyTime,String venueName) {
        if (operateUser != null) {
            this.operateId = safeTransfer(operateUser.getOid());
            this.operateName = safeTransfer(operateUser.getUserName());
            this.userName=operateUser.getUserName();
        }

        if (activity != null) {
            this.activityId = safeTransfer(activity.getOid());
            this.activityName = safeTransfer(activity.getName());
        }
        this.step=step;
        this.tkTime=surveyTime;
        this.tkVenue=venueName;
    }

    public DynamicSurveyPanel(User operateUser, Activity activity,String step,String surveyReport,Long questionnaireId,List<Survey_Info> surveyInfoList) {
        if (operateUser != null) {
            this.operateId = safeTransfer(operateUser.getOid());
            this.operateName = safeTransfer(operateUser.getUserName());
            this.userName=operateUser.getUserName();
        }

        if (activity != null) {
            this.activityId = safeTransfer(activity.getOid());
            this.activityName = safeTransfer(activity.getName());
        }
        this.step=step;
        this.surveyReport=surveyReport;
        this.questionnaireId=safeTransfer(questionnaireId);

        // 整改意见
        if(surveyInfoList!=null){
            JSONArray array=new JSONArray();
            for(Survey_Info surveyInfo : surveyInfoList){
                // 需要下次踏勘
                if(surveyInfo.isNextSurvey()) {
                    JSONObject jsonObject = new JSONObject();
                    // 整改意见
                    String zgSuggest = surveyInfo.getAnswer();
                    jsonObject.put("zgSuggest", zgSuggest);

                    // 现场勘查照片
                    String zgPhoto = "";
                    List<Survey_Photo> photoList = surveyInfo.getPhotos();
                    if (photoList != null) {
                        for (Survey_Photo photo : photoList) {
                            zgPhoto += photo.getPath() + ",";
                        }
                        if (StringUtil.isNotEmpty(zgPhoto)) {
                            zgPhoto = zgPhoto.substring(0, zgPhoto.length() - 1);
                        }
                    }
                    jsonObject.put("zgPhoto", zgPhoto);
                    array.add(jsonObject);
                }
            }
            this.reformList=array;
        }
    }

    public DynamicSurveyPanel(User operateUser, Task task, String tkzjUserList) {
        Activity activity = task.getActivity();

        if (task.getAssgin() != null) {
            this.tkUserName = safeTransfer(task.getAssgin().getUserName());
        }
        if (operateUser != null) {
            this.operateId = safeTransfer(operateUser.getOid());
            this.operateName = safeTransfer(operateUser.getUserName());
            this.userName=operateUser.getUserName();
        }

        if (activity != null) {
            this.activityId = safeTransfer(activity.getOid());
            this.activityName = safeTransfer(activity.getName());
        }
        this.tkzjUserList = tkzjUserList;
    }

    private static String safeTransfer(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }
}