package com.bcxin.survey.domain.activity;

import com.bcxin.survey.domain.BaseBean;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.*;

/**
 * 【活动】活动材料表
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ActivityMaterial")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class ActivityMaterial extends BaseBean {

	private static final long serialVersionUID = 1L;


	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;//活动
	
	private String activityMaterialType;//材料类型（字典）

	@Type(type="text")
	private String value;//材料路径

	private String commitStatus;//是否提交公安

	public Activity getActivity() {
		return activity;
	}

	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	public String getActivityMaterialType() {
		return activityMaterialType;
	}

	public void setActivityMaterialType(String activityMaterialType) {
		this.activityMaterialType = activityMaterialType;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getCommitStatus() {
		return commitStatus;
	}

	public void setCommitStatus(String commitStatus) {
		this.commitStatus = commitStatus;
	}
}
