/**
* 版本：1.9
* 更新日期：2012-01-07
* 带(B)标志的函数没有使用其他函数，可以单独提出去使用
* 带(NB)标志的函数使用了其他函数，不能单独提出去使用
*/

//(B)校验是否为整数 value:数值，例：2008
function checkInt(value) {
	var re = /^(-)?\d+$/;
	return re.test(value);
}

//(B)校验是否为正整数 value:数值，例：2008
function checkInt1(value) {
	var re = /^\d+$/;
	return re.test(value);
}
function checkPayAmount(value) {
	var re = /^[+-]?\d+(\.\d+)?$/;
	return re.test(value);
}
//(B)校验是否为负整数 value:数值，例：-2008
function checkInt2(value) {
	var re = /^-\d+$/;
	return re.test(value);
}

//(B)校验是否为浮点数 value:数值，例：2008.23
function checkDouble(value) {
	var re = /^(-)?\d+\.\d+$/;
	return re.test(value);
}

//(B)校验是否为正浮点数 value:数值，例：2008.23
function checkDouble1(value) {
	var re = /^\d+\.\d+$/;
	return re.test(value);
}

//(B)校验是否为负浮点数 value:数值，例：-2008.23
function checkDouble2(value) {
	var re = /^(-)\d+\.\d+$/;
	return re.test(value);
}

//(B)校验IP地址 value:IP地址，例：10.1.126.89
function checkIP(value) { 
	var check=function(v) { try { return ( v <= 255 && v >= 0); } catch (x) { return false; } };
	var re = value.split(".");
	return (re.length == 4) ? (check(re[0]) && check(re[1]) && check(re[2]) && check(re[3])) : false;
}

//(B)校验邮政编码 value:邮政编码的值，例：421661
function checkZipCode(value) {
	var re = /^\d{6}$/;
	return re.test(value);
}

//(B)校验电子邮件 value:电子邮件的值，例：feizg@sinosoft.com.cn
function checkEmail(value) {
	var re = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
	return re.test(value);
}

//(B)校验固定电话 value:固定电话电话的值，例：010-62205880
function checkPhone(value) {
	var re = /^(\d{3,4}-?)?\d{7,8}$/;
	return re.test(value);
}
//(B)校验移动电话 value:移动电话的值，例：13812345678
function checkMobile(value) {
	var re = /^\d{11}$/;
	return re.test(value);
}

//(B)校验日期和时间 value:日期和时间的值，例：2008-08-08 08:08:08
function checkDateTime(value) { 
	var reg = /^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2}) (\d{1,2}):(\d{1,2}):(\d{1,2})$/;
	var r = value.match(reg);
	if(r == null) return false;
	var d= new Date(r[1], r[3]-1,r[4],r[5],r[6],r[7]);
	return (d.getFullYear() == r[1] && (d.getMonth()+1) == r[3] && d.getDate() == r[4] && d.getHours() == r[5] && d.getMinutes() == r[6] && d.getSeconds() == r[7]);
}

//(B)校验日期 value:日期的值，例：2008-08-08
function checkDate(value) {
	var r = value.match(/^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2})$/);
	if(r == null) return false;
	var d= new Date(r[1], r[3]-1, r[4]);
	return (d.getFullYear() == r[1] && (d.getMonth() + 1) == r[3] && d.getDate() == r[4]);
}

//(B)校验时间 value:时间的值，例：08:08:08
function checkTime(value) {
	var r = value.match(/^(\d{1,2}):(\d{1,2}):(\d{1,2})$/);
	if(r==null)return false;
	return (r[1] < 24 && r[2] < 60 && r[3] < 60);
}

//(B)校验密码 value:密码，min:最小长度，max:最大长度 规则：必须同时包含字母和数字
function checkPasswd(value, min, max) {
	var length = value.length;
	if(length < min){
		alert("密码长度不能小于" + min + "位");
		return false;
	}
	if(length>max){
		alert("密码长度不能大于" + max + "位");
		return false;
	}
	var re = /^[^0-9]+$/;
	var flag = re.test(value);
	if(flag) {
		alert("密码没有包含数字");
		return false;
	}
	re = /^[^a-zA-Z]+$/;
	flag = re.test(value);
	if(flag) {
		alert("密码没有包含字母");
		return false;
	}
	return true;
}

//校验身份证位数与内容，必须为15位或者18位，最后一位是根据前17位计算得出，出生日期必须正确
function checkIDNo(IDNo) {
	//校验位数和最后一位
	var re = /^\d{15}(\d{2}(x|X|\d))?$/;
	if(!re.test(IDNo)) {
		return false;
	}
	//校验最后一位
	if (IDNo.length == 18) {
		if(!checkIDNoLastCode(IDNo)) {
			return false;
		}
	}
	//校验出生日期
	if(!checkDate(getBirthdayFromIDNo(IDNo))) {
		return false;
	}
	return true;
}

//校验身份证最后一位
function checkIDNoLastCode(IDNo) {
	IDNo = IDNo.toUpperCase();
	var a = [ 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1 ];
	var b = "10X98765432";
	var sum = 0;
	for ( var i = 0; i < 17; i++) {  
      sum += a[i] * IDNo[i];// 加权求和  
	}  
	var x = sum % 11;// 得到验证码所位置  
	if (IDNo[17] == b[x]) {  
		return true;  
	} else {  
		return false;  
	}  
}

//根据身份证获取出生日期，格式YYYY-MM-DD
function getBirthdayFromIDNo(IDNo) {
	var tempStr;
	if (IDNo.length == 15){
    	tmpStr = IDNo.substring(6, 12);
    	tmpStr= "19" + tmpStr;			    	
  	}else if(IDNo.length == 18){
    	tmpStr = IDNo.substring(6, 14);  	  	
  	}
	tmpStr = tmpStr.substring(0, 4) + "-" + tmpStr.substring(4, 6) + "-" + tmpStr.substring(6);
	return tmpStr;
}

//根据身份证获取性别，M-男，F-女
function getSexFromIDNo(IDNo) {
	var temp = "";
	if(IDNo.length == 15) {
		temp = IDNo.substring(14,15);
	} else {
		temp = IDNo.substring(16,17);
	}
	var x = temp % 2;
	if(x == 0) {
		return "F";
	} else {
		return "M";
	}
}

//(NB)比较两个日期，返回两个日期相差的天数，日期格式：2008-08-08
function dateCompare(date1, date2) {
	var dateflag = checkDate(date1) && checkDate(date2);
	if(!dateflag) {
		alert("dateCompare:日期格式不正确");
		return 0;
	}
	var s1 = date1.split("-");
	var s2 = date2.split("-");
	var d1 = new Date(s1[0], s1[1]-1, s1[2]);
	var d2 = new Date(s2[0], s2[1]-1, s2[2]);
	return (d2 - d1) / (3600 * 24 * 1000);
}

//(NB)计算年龄,sDate1出生日期,sDate2当前日期,日期格式：2008-08-08
function calAge(sDate1, sDate2) {
	var dateflag = checkDate(sDate1) && checkDate(sDate2);
	if(!dateflag) {
		alert("calAge:日期格式不正确");
		return 0;
	}
    var aDate1 = sDate1.split("-");
    var aDate2 = sDate2.split("-");
    var d1 = new Date(aDate1[0], aDate1[1]-1, aDate1[2]);
    var d2 = new Date(aDate2[0], aDate2[1]-1, aDate2[2]);
    var s1 = d1.getFullYear();
    var s2 = d1.getMonth() + 1;
    var s3 = d1.getDate();
    var e1 = d2.getFullYear();
    var e2 = d2.getMonth() + 1;
    var e3 = d2.getDate();
    var diffYears = e1 - s1;
    if(e2 < s2 || (e2 == s2 && e3 < s3)) diffYears = diffYears - 1;
    return diffYears;
}

//(NB)在原有日期date1(日期格式：2008-08-08)的基础上增加整数x(年或月或日),unit为x的单位(Y-年 M-月 D-日)
function dateAdd(date1, x, unit) {
	var dateflag = checkDate(date1);
	if(!dateflag) {
		alert("dateAdd:日期格式不正确");
		return date1;
	}
	var aDate = date1.split("-");
	if(unit == "Y" || unit == "y") {	//年
		aDate[0] = aDate[0] - (-x);
		var d1 = new Date(aDate[0], aDate[1]-1, 1);
		var d2 = new Date(aDate[0], aDate[1], 1);
		var diff = (d2 - d1) / (3600 * 24 * 1000);			//该月的最大天数
		if(diff < aDate[2]) aDate[2] = diff;
	} else if(unit == "M" || unit == "m") {	//月
		aDate[1] = aDate[1] - (-x);
		while(aDate[1] > 12){
			aDate[0] = aDate[0] - (-1);
			aDate[1] = aDate[1] - 12;
		}
		while(aDate[1] < 1){
			aDate[0] = aDate[0] - 1;
			aDate[1] = aDate[1] - (-12);
		}
		var d1 = new Date(aDate[0], aDate[1] - 1, 1);
		var d2 = new Date(aDate[0], aDate[1], 1);
		var diff = (d2 - d1) / (3600 * 24 * 1000);			//该月的最大天数
		if(diff < aDate[2]) aDate[2] = diff;
	} else if(unit == "D" || unit == "d"){	//日
		var d = new Date(aDate[0], aDate[1] - 1, aDate[2]);
		var tmp = d.getTime() + parseInt(x) * 3600 * 1000 * 24;
		var dd = new Date(tmp);
		aDate[0] = dd.getFullYear();
		aDate[1] = dd.getMonth() + 1;
		aDate[2] = dd.getDate();
	}
	return aDate[0] + "-" + aDate[1] + "-" + aDate[2];
}

//(B)计算字符串的长度(中文按2个字节计算) value:数值，例：qweerrr
function getStringLength(value) { 
	var sTmpStr = new String(value);
	var sTmpChar;
	var nOriginLen = sTmpStr.length;
	var nStrLength = 0;
	for(var i = 0; i < nOriginLen; i++){
		sTmpChar = sTmpStr.charAt(i);
		if(escape(sTmpChar).length > 4){
			nStrLength += 2;
		} else if(sTmpChar != '\r'){
			nStrLength++;
		}
	}
	return nStrLength;
}

//(B)获取字符串的子串 value:字符串，len:需要截取的长度(按字节计算)
function getSubByLength(value, len) { 
	var sTmpStr = new String(value);
	var sTmpChar;
	var nOriginLen = sTmpStr.length;
	var nStrLength = 0;
	for(var i = 0; i < nOriginLen; i++){
		sTmpChar = sTmpStr.charAt(i);
		if(escape(sTmpChar).length > 4){
			nStrLength += 2;
		} else if(sTmpChar != '\r'){
			nStrLength++;
		}
		if(nStrLength >= len) return value.substring(0, i + 1);
	}
	return value;
}

//(B)预览图片 支持 IE6、IE7 imgFile:图片来源，src:图片显示位置，width:图片显示宽度，height:图片显示高度
function PreviewImg(imgFile, src, width, height) {
	var newPreview = document.getElementById(src);
	newPreview.innerHTML = "";
	newPreview.filters.item("DXImageTransform.Microsoft.AlphaImageLoader").src = imgFile;
	newPreview.style.width = width;
	newPreview.style.height = height;
}

//(B)检查图片路径与格式是否正确 支持的格式包括bmp,jpg,jpeg,gif,png  value:图片的完整路径
function checkPicture(value) {
	if(value.indexOf(":") < 0 || value.indexOf(".") < 0) {
		alert("图片不存在或路径不正确");
		return false;
	}
	str1 = value.substring(value.indexOf(".") + 1).toLowerCase();
	if("bmp" == str1 || "jpg" == str1 || "jpeg" == str1 || "gif" == str1 || "png" == str1) return true;
	else {
		alert("图片格式不正确");
		return false;
	}
}

//(B)检查是否所有项不为空 true-所有项不为空 false-至少有一项项为空 str:字符串数组
function checkRequired(str) {
	for(var i = 0; i < str.length; i++) {
		if(document.getElementById(str[i]).value == ""){
			return false;
		}
	}
	return true;
}
//(B)获取当天的日期
function getCurrentDate() {
	var date = new Date();
	return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
}

//(B)获取昨天的日期
function getYesterday() {
	var d1 = new Date();
	var date = new Date(d1.getFullYear(), d1.getMonth(), d1.getDate() - 1);
	return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
}

//(B)获取明天的日期
function getTomorrow() {
	var d1 = new Date();
	var date = new Date(d1.getFullYear(), d1.getMonth(), d1.getDate() + 1);
	return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
}

//封装动态表格
//删除一行，tableObj为table对象，rowIndex为第几行
function deleteRow(tableObj, rowIndex){
	tableObj.deleteRow(rowIndex);
}

//添加一行，tableObj为table对象，array第一列为TD的classname，第二列为innerhtml，可以添加多列
function addRow(tableObj, array) {
	//获取浏览器
	var explorerVersion;
	var temp = navigator.userAgent.toLowerCase();
	if(temp.match(/msie ([\d.]+)/)) {
		explorerVersion = "IE";
	} else if(temp.match(/firefox\/([\d.]+)/)) {
		explorerVersion = "FF";
	} else {
		explorerVersion = "OTHER";
	}
	//增加一行
	var getTR = function() {
		if(explorerVersion.indexOf("IE") == 0) {
			return tableObj.insertRow();
		} else if(explorerVersion.indexOf("FF") == 0) {
			return tableObj.insertRow(-1);
		} else {
			return tableObj.insertRow(tableObj.rows.length);
		}
	}
	//增加一列
	var getTD = function(x) {
		if(explorerVersion.indexOf("IE") == 0) {
			return TR.insertCell();
		} else if(explorerVersion.indexOf("FF") == 0) {
			return TR.insertCell(-1);
		} else {
			return TR.insertCell(x);
		}
	}
	var TR = getTR();
	var TD;
	var length = tableObj.rows.length;
	for(var i = 0; i < array.length; i++) {
		TD = getTD(i);
		TD.className = array[i][0];
		TD.innerHTML = array[i][1];
	}
}
//封装动态表格结束
function buildForm(name, value){
	var form = document.createElement("form");
	document.body.appendChild(form);
	form.addInput = function(a,b,c){
		var input = document.createElement("input");
		input.type = a;
		input.name = b;
		input.value = c;
		form.appendChild(input);
	}
	for(var i = 0; i < name.length; i++) {
		form.addInput("hidden", name[i], value[i]);
	}
	return form;
}
//传值到下一页，action为下一页的url地址，target为打开方式，如_self、_blank等，name为传值的名称，value为传递的值
function transfer(action, target, name, value) {
	var form=buildForm(name, value);
	form.action = action;
	form.target = target;
	form.method = "post";
	form.submit();
}