package com.bcxin.survey.service.wechat;

import com.aspose.words.*;
import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.dao.report.MaterialTaskDao;
import com.bcxin.survey.domain.data.MaterialTask;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.Survey_FeedBack;
import com.bcxin.survey.domain.survey.Survey_Info;
import com.bcxin.survey.domain.survey.Survey_Photo;
import com.bcxin.survey.domain.survey.Survey_Questionnaire;
import com.bcxin.survey.utils.*;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 */
@Service
@Transactional
public class SurveyQuestionnaireServiceImpl implements SurveyQuestionnaireService{
	
	@Autowired
	private BaseDao baseDao;
	
	@Autowired
	private SurveyFeedBackService feedBackService;
	
	@Autowired
	private SurveyInfoService surveyInfoService;

	@Autowired
	private SurveyTaskService surveyTaskService;

	@Resource
	private MaterialTaskDao materialTaskDao;
	
	final static Logger logger = LoggerFactory.getLogger(SurveyQuestionnaireServiceImpl.class);
	
	@Value("${report_mail_cc}")
	private String report_mail_cc;
	
	@Override
	public boolean saveOrUpdate(Survey_Questionnaire questionnaire){
		boolean flag = true;
		try {
			questionnaire.setUpdateOn(new Date());
			baseDao.saveOrUpdate(questionnaire);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean delete(Survey_Questionnaire questionnaire) {
		boolean flag = true;
		try {
			baseDao.delete(questionnaire);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}
	
	@Override
	public Survey_Questionnaire findQuestionnaireByOid(long oid){
		return baseDao.get(Survey_Questionnaire.class, oid);
	}
	

	@Override
	@SuppressWarnings("unchecked")
	public Survey_Questionnaire findQuestionnaireByFeedBackIdAndAddressId(long feedBackId,long addressId){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("feedBack.oid", feedBackId));
		criterionList.add(Restrictions.eq("venue.oid", addressId));
		List<Order> orderList = new ArrayList<Order>();
		orderList.add(Order.asc("feedBack.oid"));
		List<Survey_Questionnaire> questionnaires = baseDao.findByCriterion(Survey_Questionnaire.class, criterionList,orderList);
		if(questionnaires != null && questionnaires.size() > 0) {
			return questionnaires.get(0);
		}
		
		return null;
		
	}


	/**
	 * 生成踏勘报告
	 * @param questionnaire
	 * @return
	 */
	@Override
	public String createSurveyReport(Survey_Questionnaire questionnaire,MaterialTask materialTask){
		FileOutputStream fileOS = null;
		InputStream license = null;
		InputStream word = null;
		String surveyReport="";
		try {
			license = SurveyQuestionnaireServiceImpl.class.getClassLoader().getResourceAsStream("license.xml");// license路径
		    word = SurveyQuestionnaireServiceImpl.class.getClassLoader().getResourceAsStream("template/surveyReport.doc");
		    
		    License aposeLic = new License();
	        aposeLic.setLicense(license);
	        
	        long old = System.currentTimeMillis();
	        Document docAll = new Document(word);
        	int questionIndex =1;
        	boolean haveReport = false;
        	List<Survey_Info> surveyInfos = surveyInfoService.findSurveyInfoListByQuestionnaireId(questionnaire.getOid());

        	Survey_FeedBack feedBack = feedBackService.findSurveyFeedBackByOid(questionnaire.getFeedBack().getOid());
	        for (Survey_Info info:surveyInfos) {
	        	if (StringUtil.isNotEmpty(info.getAnswer())) {
		        	String[] questionFieldNames = new String[]{"question","answer"};
		        	String question = questionIndex +"."+ info.getQuestion();
		        	String answer = info.getAnswer();
		        	
		        	Object[] questionValues=new Object[]{question,answer};
		        	InputStream wordDetail = SurveyQuestionnaireServiceImpl.class.getClassLoader().getResourceAsStream("template/reportDetail.doc");
	            	Document doc = new Document(wordDetail);
	            	doc.getMailMerge().execute(questionFieldNames, questionValues);
	            	DocumentBuilder builder = new DocumentBuilder(doc);
	            	builder.moveToMergeField("img");
	            	for(Survey_Photo photo:info.getPhotos()){
	            		try {
							builder.insertImage(photo.getPath(), 150, 160);
							builder.write("  ");
						} catch (Exception e){
	            			logger.error("图片插入失败，path="+photo.getPath());
						}
	            	}
	            	doc.getFirstSection().getPageSetup().setSectionStart(SectionStart.CONTINUOUS);
	            	docAll.appendDocument(doc, ImportFormatMode.KEEP_SOURCE_FORMATTING); 
		        	questionIndex++;
		        	haveReport = true;
	        	}
	        }
	        
            if (haveReport) {
            	User user = feedBack.getUser();
	            String[] fieldNames=new String[]{"header","title","surveyStep","pageCount"};
		        String title = questionnaire.getFeedBack().getSurveyTask().getName();
		        title = title + "--"+questionnaire.getVenue().getName()+"";
		        String surveyStep = questionnaire.getFeedBack().getSurveyStep().getName()+"报告";
		        String header = title+surveyStep;
		        int pageCount = docAll.getPageCount();//获得页数
		        Object[] values=new Object[]{header,title,surveyStep,pageCount};
		        docAll.getMailMerge().execute(fieldNames, values);


				String[] folderPath = new String[]{ConfigUtil.material(), cn.hutool.core.date.DateUtil.today()};
				String dir = FileUtils.appendFolderPath(folderPath);
				String fileName = FileUtils.packTimestamp(questionnaire.getOid()+"") + ".doc";
				String detailPath = dir + fileName;
				// 输出路径
	            File file = new File(detailPath);
	            fileOS = new FileOutputStream(file);
	            docAll.save(fileOS, SaveFormat.DOC);

	            // 踏勘报告路径
	            surveyReport = ConfigUtil.getValue("tk_url") + "getResourceFullPath.do?fullPath=" + detailPath;
		        questionnaire.setReportPath(surveyReport);
		        saveOrUpdate(questionnaire);

				logger.debug("upload oss path：" + questionnaire.getReportPath());
		        EmailUtil emailUtil = new EmailUtil();
		        if(StringUtil.isEmpty(report_mail_cc)){
		        	report_mail_cc = "takanbaogao@baichuanxin.com";
		        }
		        emailUtil.sendEmail(title+surveyStep, "尊敬的勘查人员"+user.getRealName()+":<br/>&nbsp;&nbsp;&nbsp;&nbsp;您好，附件是"+title+surveyStep+"，请查收!",user.getEmail() , file);
		        emailUtil.sendEmail(title+surveyStep, "尊敬的勘查人员"+user.getRealName()+":<br/>&nbsp;&nbsp;&nbsp;&nbsp;您好，附件是"+title+surveyStep+"，请查收!",report_mail_cc , file);
	            long now = System.currentTimeMillis();
				logger.debug("共耗时：" + ((now - old) / 1000.0) + "秒\n\n" + "文件保存在:" + file.getPath());
	            System.out.println("共耗时：" + ((now - old) / 1000.0) + "秒\n\n" + "文件保存在:" + file.getPath());

	            if (materialTask != null) {
					materialTask.setSuccess(DictConst.Y);
					materialTaskDao.update(materialTask);
				}
	        }
			return surveyReport;
		} catch (Exception e) {
			logger.error(e.toString());
			e.printStackTrace();
			return "";
		} finally {
			try {
				if (fileOS != null) {
					fileOS.close();
				}
				if (license != null) {
					license.close();
				}
				if (word != null) {
					word.close();
				}
			} catch (IOException e){
				e.printStackTrace();
			}
		}
	}

}
