package com.bcxin.survey.domain.data;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;

/**
 * 基础数据（省市县）
 * @author luopeng
 *
 */
@Entity
@Table(name = "sys_Region")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = Region.class)
public class Region implements Serializable {

	private static final long	serialVersionUID	= 1L;

	@Id
	@GeneratedValue(generator = "hilo")
	@GenericGenerator(name = "hilo", strategy = "hilo")
	@Column(unique = true, nullable = false)
	private Long oid;

	//省和直辖市
	private String province;

	//市/县
	private String city;

	//区
	private String area;

	//父级
	private String parent_id;

	//区域级别
	private String level;

	public Long getOid() {
		return oid;
	}

	public void setOid(Long oid) {
		this.oid = oid;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getParent_id() {
		return parent_id;
	}

	public void setParent_id(String parent_id) {
		this.parent_id = parent_id;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}
	
}
