package com.bcxin.survey.dao.report;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public class DraftDBConnection {
		
	public Connection getDraftConnection() throws Exception {
		InputStream is = this.getClass().getClassLoader().getResourceAsStream("jdbc.properties");
		Properties property = new Properties();
		property.load(is);
		String driverClassName = property.getProperty("risk.draft.jdbc.driverClassName");
		String url = property.getProperty("risk.draft.jdbc.url");
		String username = property.getProperty("risk.draft.jdbc.username");
		String password = property.getProperty("risk.draft.jdbc.password");
		Connection conn = null;
		try {
			Class.forName(driverClassName);
			conn = DriverManager.getConnection(url, username, password);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return conn;
	}
	
	public Connection getDataTransferConnection() throws Exception {
		InputStream is = this.getClass().getClassLoader().getResourceAsStream("jdbc.properties");
		Properties property = new Properties();
		property.load(is);
		String driverClassName = property.getProperty("risk.dataTransfer.jdbc.driverClassName");
		String url = property.getProperty("risk.dataTransfer.jdbc.url");
		String username = property.getProperty("risk.dataTransfer.jdbc.username");
		String password = property.getProperty("risk.dataTransfer.jdbc.password");
		Connection conn = null;
		try {
			Class.forName(driverClassName);
			conn = DriverManager.getConnection(url, username, password);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return conn;
	}
}
	
