package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.UserRoleDao;
import com.bcxin.risk.user.domain.RoleMenu;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.domain.UserRole;
import com.bcxin.risk.user.dto.search.UserRoleSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("userRole")
@SuppressWarnings("unchecked")
public class UserRoleDaoImpl extends DaoImpl<UserRole> implements UserRoleDao {

    @Override
    public List<UserRole> findUserRoleByName(String name, Page page) {

        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("userName", name));
        Order order = Order.desc("createon");
        return selectPage(criterionList,page,order);
    }
    @Override
    public List<UserRole> findUserRoleByUserid(long userid, Page page) {
        return selectPage(Restrictions.eq("user_id", userid), page);
    }

    public UserRole findUserRoleByOid(Long oid){
        return selectById(oid);
    }

//    @Override
//    public List<UserRole> findUserRoleList(UserRoleSearchDto searchDto, Page page) {
//        List<Criterion> criterionList = Lists.newArrayList();
//        if ( searchDto.getUser() != null ) {
//            criterionList.add(Restrictions.eq("user", searchDto.getUser()));
//        }
//        if ( searchDto.getRole() != null ) {
//            criterionList.add(Restrictions.eq("Role", searchDto.getRole()));
//        }
//        if ( page == null ) {
//            return selectList(criterionList);
//        }
//        return selectPage(criterionList,page);
//    }

    public void deleteUserRole(UserRole userRole){
        SelectWrapper wrapper = SelectWrapper.instance();
        if (userRole.getRole() != null){
            wrapper.eq("role_id", userRole.getRole().getOid());
        }
        if (userRole.getUser() != null){
            wrapper.eq("user_id", userRole.getUser().getOid());
        }
        delete(wrapper);
    }


    public void insertUserRole(List<UserRole> userRoleList){

        String sql = "INSERT INTO risk_user_role (createOn,"+
                                                     "role_id,"+
                                                     "user_id)"+
                                           " VALUES ";
        for(UserRole userRole : userRoleList){
            sql += "(SYSDATE(),"+ userRole.getRole().getOid() +","+ userRole.getUser().getOid() +"),";
        }
        sql = sql.substring(0,sql.length()-1);
        executeSqlUpdate(sql);
    }

    @Override
    public void deleteByUser(User user){
        SelectWrapper wrapper = SelectWrapper.instance();
        if (user != null){
            wrapper.eq("user_id", user.getOid());
        }
        delete(wrapper);
    }

}
