package com.bcxin.risk.sys;

import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import org.springframework.stereotype.Repository;


/**
 * @author 张建华
 * @date 2018年7月10日11:21:28
 */
@Repository("SysTipsDao")
public class SysTipsDaoImpl extends DaoImpl<SysTips> implements SysTipsDao {

    @Override
    public SysTips selectSysTipsByProvinceCode(String provinceCode) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("provinceCode", provinceCode);
        return selectOne(wrapper);
    }

    @Override
    public SysTips selectTipsByProvinceCode(String provinceCode) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("provinceCode", provinceCode);
        wrapper.notIn("status", DictConst.N);
        return selectOne(wrapper);
    }
}
