package com.bcxin.risk.report.material;

import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormMenuTemplateDao;
import com.bcxin.risk.report.material.domain.MaterialFormMenuTemplate;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class MaterialFormMenuTemplateDaoImpl extends DaoImpl<MaterialFormMenuTemplate> implements MaterialFormMenuTemplateDao {

	@Override
	public List<MaterialFormMenuTemplate> findAll() {
		return selectList();
	}

	@Override
	public List<MaterialFormMenuTemplate> findByMenus(List<String> menuCodeList) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.in("menuCode", menuCodeList));
		return selectList(criterionList);
	}
}
