package com.bcxin.risk.log;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

@Repository("SpFileSyncLogDao")
public class SPFileSyncLogDaoImpl extends DaoImpl<SPFileSyncLog> implements SPFileSyncLogDao{

    @Override
    public List<SPFileSyncLog> findExistsLogFile(Collection<String> fileList) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.in("fileName",fileList));
        return selectList(criterionList);
    }

    @Override
    public SPFileSyncLog findByName(String fileName) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("fileName", fileName));
        List list = selectList(criterionList);
        if (CollectionUtil.isNotEmpty(list)) {
            return (SPFileSyncLog)list.get(0);
        }
        return null;
    }

}
