package com.bcxin.risk.log;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.log.dto.dto.FileSyncLogDTO;
import com.bcxin.risk.log.dto.search.SyncFileLogSearchDTO;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("fileSyncLogDao")
public class FileSyncLogDaoImpl extends DaoImpl<FileSyncLog> implements FileSyncLogDao{

    @Override
    public List<FileSyncLogDTO> findList(SyncFileLogSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                " DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn," +
                " DATE_FORMAT(a.syncTime,'%Y-%m-%d %H:%i:%s') AS syncTime," +
                " a.fileName,"+
                " a.dir,"+
                " a.sync"+
                " from log_filesynclog a ";

        if ( StringUtil.isNotEmpty(searchDto.getSync())) {
            wrapper.eq("sync",searchDto.getSync());
        }
        if (StringUtil.isNotEmpty(searchDto.getFileName()) ) {
            wrapper.like("fileName", searchDto.getFileName());
        }

        wrapper.orderBy("a.createOn",false);
        wrapper.orderBy("a.oid",false);
        List<FileSyncLogDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            FileSyncLogDTO dto = new FileSyncLogDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;

    }

    @Override
    public List<FileSyncLog> findExistsLogFile(List<String> fileList) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.in("fileName",fileList));
        return selectList(criterionList);
    }

    @Override
    public FileSyncLog findByName(String fileName) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("fileName", fileName));
        List list = selectList(criterionList);
        if (CollectionUtil.isNotEmpty(list)) {
            return (FileSyncLog)list.get(0);
        }
        return null;
    }

}
