package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class ActivityApprovalDaoImpl extends DaoImpl<ActivityApproval> implements ActivityApprovalDao{

    @Override
    public List<ActivityApproval> findByActivityAndApproveStatus(Activity activity, String approveStatus){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("activity",activity);
        if(StringUtil.isNotEmpty(approveStatus)){
            wrapper.notIn("approvalStatus",approveStatus);
        }
        return selectList(wrapper);
    }

    @Override
    public List<ActivityApproval> findByActivityIdAndApproveStatus(Long activityId, String approveStatus){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("activity_id",String.valueOf(activityId));
        if(StringUtil.isNotEmpty(approveStatus)){
            wrapper.notIn("approvalStatus",approveStatus);
        }
        wrapper.orderBy("approvalDate",false);
        return selectList(wrapper);
    }

    @Override
    public List<ActivityApproval> findByActivity(Activity activity){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("activity",activity);
        wrapper.orderBy("approvalDate",false);
        return selectList(wrapper);
    }

}
