package com.bcxin.risk.report.material.dao;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.report.dto.data.MaterialFormValueDTO;
import com.bcxin.risk.report.dto.search.MaterialFormValueSearchDTO;
import com.bcxin.risk.report.material.domain.MaterialFormAttr;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.domain.MaterialFormValue;
import com.bcxin.risk.report.material.dto.MaterialComposeValueDTO;

import java.util.List;
import java.util.Map;

public interface MaterialFormValueDao extends IDao<MaterialFormValue> {

	MaterialFormValue findByActivityAttr(Activity activity, MaterialFormAttr attr, int seq);

	MaterialFormValue findByOid(Long oid);
	
	List<MaterialFormValue> findByActivityAttr(Activity activity, MaterialFormAttr attr);

	List<String> findByActivityAttr(Activity activity, String attrCode);

	List<MaterialComposeValueDTO> findByReport(Long report_id);

	List<MaterialFormValueDTO> findDTOByActivityAttrs(Long activityId,List<String> attrCodes);

	List<MaterialFormValue> findByActivity(Activity activity);

	List<MaterialFormValue> findByActivityAndAttrs(Activity activity,List<MaterialFormAttr> attrList);

	List<MaterialFormValueDTO> findByActivity(MaterialFormValueSearchDTO searchDTO);

	List<MaterialFormValueDTO> findMultiSeqByActivity(MaterialFormValueSearchDTO searchDTO);

	List<MaterialFormValueDTO> findMultiOrgValues(Activity activity, String menuCode);

	int deleteByActivityAndAttrs(Activity activity, List<Long> attrIds, int seq);

	int findMaxSeq(Activity activityId, MaterialFormMenu menuId);

	List<MaterialFormValueDTO> findMultiFormValues(Activity activity, MaterialFormMenu menu,String ignoreSeq);
	
	void updateValue(String value,Long oid);

	void deleteByActivityId(Long activityId);

	List<Map<String,Object>> selectFormValueMap(Long activityId, Long menuId);

}
