package com.bcxin.risk.policy;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.dto.data.PolicyDto;
import com.bcxin.risk.policy.dto.search.PolicySearchDto;
import com.bcxin.risk.user.domain.User;

import java.util.List;

public interface InsurancePolicyDao extends IDao<InsurancePolicy> {
	
	List<InsurancePolicy> findPolicyByUser(User user);
	
	List<PolicyDto> findPolicyList(PolicySearchDto searchDto, DwzPage page);

	InsurancePolicy findInsurancePolicyByOid(Long oid);
	InsurancePolicy findInsurancePolicyByExNo(String exNo);

	List<InsurancePolicy> findInsurancePolicyList(PolicySearchDto searchDto, Page page);

	public List<PolicyDto> findPolicyByUserPage(PolicySearchDto searchDto,Page page);

	void closeExpirePolicy();
	void updateSyncStatus(String externalReference);

	List<PolicyDto> findUnSyncPolicyList();
}
