package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.search.ActivitySearchDTO;
import com.bcxin.risk.common.dto.search.ParamDTO;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;

import java.util.List;
import java.util.Map;

public interface ActivityDao extends IDao<Activity> {

    List<Activity> activityList();

    Activity findActivityByActivityNo(String orderNo);

    List<Activity> findUnendActivity(String userId);

    List<Activity> findActivityByActivityName(String activityName,String filterId);

    Activity findActivityByOid(Long oid);

    List<ActivityDataDTO> findActivityDtoList(ActivitySearchDTO searchDto, Page page);

    Map<String, String> countActivity(ActivitySearchDTO dto);

    List<ActivityDataDTO> findActivityByApprovalStatus(ActivitySearchDTO activitySearchDTO, Page page);

    List<ActivityDataDTO> activityDataDTOList(ParamDTO paramDTO, Page page);

    List<ActivityDataDTO> pgbgDataDTOList(ParamDTO paramDTO, Page page);

    void cancelActivity(Long activityId);

    List listActivity(DwzPage page, ActivitySearchDTO searchDTO);

    List<Map<String, Object>> listMaterialPath(String oid, String activityMaterialType);

    /**
     * 更新标记为已推送，好差评系统
     *
     * @param activityId
     */
    void updatePushSignForGoodBadComment(Long activityId);

    /**
     * 获取未推送好差评系统的所有项
     *
     * @return
     */
    List<Activity> findNotPushForGoodBadComment();

    /**
     * 浙江政务2.0赋码是否存在
     * @return
     */
    boolean isExist(String zwId);

    String selectLastActivityProjId(String areaCode);

    /**
     * 浙江政务2.0，根据zwId查找activity oid
     *
     */
    Activity findActivityByZwId(String zwId);

    List<ActivityDataDTO> activityServiceOrgDataDTOList(ParamDTO paramDTO, Page page);
}
