/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.InsurancePolicyDao;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.dto.data.PolicyDto;
import com.bcxin.risk.policy.dto.search.PolicySearchDto;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="insurancePolicyDao")
public class InsurancePolicyDaoImpl
extends DaoImpl<InsurancePolicy>
implements InsurancePolicyDao {
    public InsurancePolicy findInsurancePolicyByOid(Long oid) {
        return (InsurancePolicy)this.selectById(oid);
    }

    public InsurancePolicy findInsurancePolicyByExNo(String exNo) {
        List list = this.selectList(CriterionWrapper.instance().eq("externalReference", (Object)exNo));
        if (list.size() > 0) {
            return (InsurancePolicy)list.get(0);
        }
        return null;
    }

    public List<InsurancePolicy> findInsurancePolicyList(PolicySearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getUser() != null) {
            criterionList.add(Restrictions.eq((String)"userId", (Object)searchDto.getUser().getOid()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStatus())) {
            criterionList.add(Restrictions.eq((String)"policyStatus", (Object)searchDto.getStatus()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeywords())) {
            criterionList.add(Restrictions.or((Criterion[])new Criterion[]{Restrictions.like((String)"externalReference", (Object)searchDto.getKeywords()), Restrictions.like((String)"orderNo", (Object)searchDto.getKeywords()), Restrictions.like((String)"applicantName", (Object)searchDto.getKeywords()), Restrictions.like((String)"productName", (Object)searchDto.getKeywords()), Restrictions.like((String)"insuranceName", (Object)searchDto.getKeywords()), Restrictions.like((String)"insuranceObject", (Object)searchDto.getKeywords())}));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public List<InsurancePolicy> findPolicyByUser(User user) {
        return this.selectList(CriterionWrapper.instance().eq("userId", (Object)user.getOid()));
    }

    public List<PolicyDto> findPolicyList(PolicySearchDto searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,i.blbOrderId,i.orderNo,i.applicantName,i.productName,i.insuranceName,i.insuranceObject,i.policyStatus,i.premium as amount  ,i.policyURL,i.invoiceURL,i.inceptionDate,i.plannedEndDate,i.signedDate,IF(i.policyStatus='6','\u4fdd\u969c\u4e2d',IF(i.policyStatus='12','\u5df2\u5931\u6548','')) policyStatusCN ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn  from risk_insurancepolicy i where 1=1 ";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + "and i.signedDate <= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + "and i.signedDate >= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeywords())) {
            sql = sql + "and (i.orderNo like '%" + searchDto.getKeywords() + "%' OR i.externalReference like '%" + searchDto.getKeywords() + "%' OR i.applicantName like '%" + searchDto.getKeywords() + "%' OR i.productName like '%" + searchDto.getKeywords() + "%' OR i.insuranceName like '%" + searchDto.getKeywords() + "%' OR i.insuranceObject like '%" + searchDto.getKeywords() + "%' )";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStatus())) {
            sql = sql + "and i.policyStatus = '" + searchDto.getStatus() + "' ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " ORDER BY  i.createOn DESC ,i.oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage() + " ";
        }
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            PolicyDto dto = new PolicyDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<PolicyDto> findPolicyByUserPage(PolicySearchDto searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,i.blbOrderId,i.orderNo,i.applicantName,i.productName,i.insuranceName,i.insuranceObject,i.policyStatus,i.premium as amount  ,i.policyURL,i.invoiceURL,i.inceptionDate,i.plannedEndDate,i.signedDate,IF(i.policyStatus='6','\u4fdd\u969c\u4e2d',IF(i.policyStatus='12','\u5df2\u5931\u6548','')) policyStatusCN ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn  from risk_insurancepolicy i where i.userId = " + searchDto.getUser().getOid() + " ";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + "and i.signedDate <= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + "and i.signedDate >= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeywords())) {
            sql = sql + "and (i.orderNo like '%" + searchDto.getKeywords() + "%' OR i.externalReference like '%" + searchDto.getKeywords() + "%' OR i.applicantName like '%" + searchDto.getKeywords() + "%' OR i.productName like '%" + searchDto.getKeywords() + "%' OR i.insuranceName like '%" + searchDto.getKeywords() + "%' OR i.insuranceObject like '%" + searchDto.getKeywords() + "%' )";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStatus())) {
            sql = sql + "and i.policyStatus = '" + searchDto.getStatus() + "' ";
        }
        wrapper.orderBy(" i.createOn", false);
        wrapper.orderBy(" i.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            PolicyDto dto = new PolicyDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void closeExpirePolicy() {
        String sql = "UPDATE risk_insurancepolicy SET policyStatus = '12',updateOn = NOW() WHERE policyStatus = '6' AND DATE_ADD(plannedEndDate, INTERVAL 1 DAY) < NOW() ";
        this.executeSqlUpdate(sql);
    }

    public void updateSyncStatus(String externalReference) {
        String sql = "UPDATE risk_insurancepolicy SET isSync = 1,updateOn = NOW() WHERE externalReference = '" + externalReference + "'";
        this.executeSqlUpdate(sql);
    }

    public List<PolicyDto> findUnSyncPolicyList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select userId,externalReference from risk_insurancepolicy where policyStatus = '6' and isSync = 0";
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            PolicyDto dto = new PolicyDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }
}

