/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.GovOrg;
import com.bcxin.risk.org.domain.GovOrgDao;
import com.bcxin.risk.org.dto.OrgDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="govOrgDao")
public class GovOrgDaoImpl
extends DaoImpl<GovOrg>
implements GovOrgDao {
    @Autowired
    private BaseDao baseDao;

    public GovOrg findGovOrgByOid(Long oid) {
        return (GovOrg)this.selectById(oid);
    }

    public GovOrg findGovOrgByUserName(String userName) {
        OrgDto dto = new OrgDto();
        dto.setUserName(userName);
        List<GovOrg> orgList = this.findGovOrgList(dto, null);
        if (CollectionUtil.isNotEmpty(orgList)) {
            return orgList.get(0);
        }
        return null;
    }

    public List<GovOrg> findGovOrgList(OrgDto orgDto, DwzPage page) {
        HashMap params = Maps.newHashMap();
        ArrayList criterionList = Lists.newArrayList();
        if (orgDto != null) {
            if (StringUtil.isNotEmpty((String)orgDto.getUserName())) {
                criterionList.add(Restrictions.eq((String)"userName", (Object)orgDto.getUserName()));
            }
            if (StringUtil.isNotEmpty((String)orgDto.getName())) {
                criterionList.add(Restrictions.like((String)"name", (Object)("%" + orgDto.getName() + "%")));
            }
            if (StringUtil.isNotEmpty((String)orgDto.getApprovalStatus())) {
                criterionList.add(Restrictions.eq((String)"approvalStatus", (Object)orgDto.getApprovalStatus()));
            }
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.asc((String)"approvalStatus"));
        orderList.add(Order.desc((String)"createOn"));
        if (page == null) {
            return this.baseDao.findByCriterion(GovOrg.class, (List)criterionList, orderList);
        }
        return this.baseDao.findByCriterionForPage(GovOrg.class, (List)criterionList, page, orderList);
    }
}

