/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.log;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.log.FileSyncLog;
import com.bcxin.risk.log.FileSyncLogDao;
import com.bcxin.risk.log.dto.dto.FileSyncLogDTO;
import com.bcxin.risk.log.dto.search.SyncFileLogSearchDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="fileSyncLogDao")
public class FileSyncLogDaoImpl
extends DaoImpl<FileSyncLog>
implements FileSyncLogDao {
    public List<FileSyncLogDTO> findList(SyncFileLogSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn, DATE_FORMAT(a.syncTime,'%Y-%m-%d %H:%i:%s') AS syncTime, a.fileName, a.dir, a.sync from log_filesynclog a ";
        if (StringUtil.isNotEmpty((String)searchDto.getSync())) {
            wrapper.eq("sync", (Object)searchDto.getSync());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getFileName())) {
            wrapper.like("fileName", searchDto.getFileName());
        }
        wrapper.orderBy("a.createOn", false);
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            FileSyncLogDTO dto = new FileSyncLogDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<FileSyncLog> findExistsLogFile(List<String> fileList) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.in((String)"fileName", fileList));
        return this.selectList(criterionList);
    }

    public FileSyncLog findByName(String fileName) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"fileName", (Object)fileName));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (FileSyncLog)list.get(0);
        }
        return null;
    }
}

