package com.bcxin.tenant.apis.impls;

import cn.hutool.core.util.IdcardUtil;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.ConfigRpcProvider;
import com.bcxin.api.interfaces.identities.requests.XlcpLoginRequest;
import com.bcxin.api.interfaces.tenants.SingleLoginRpcProvider;
import com.bcxin.api.interfaces.tenants.responses.LoginUserResponse;
import com.bcxin.tenant.domain.configs.SSOConfig;
import com.bcxin.tenant.domain.dto.SingleLoginUserDto;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.dtos.EmployeeDetailDto;
import com.bcxin.tenant.domain.readers.dtos.LoginUserDto;
import com.bcxin.tenant.domain.readers.dtos.TenantUserCredentialsDto;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.services.NaturalSingleLoginService;
import com.bcxin.tenant.domain.services.SingleLoginService;
import com.bcxin.tenant.domain.utils.encry.AES;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.SyncUserRoleCommand;
import org.apache.dubbo.config.annotation.DubboService;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author linqinglin
 * @date 2021/12/21 0021 14:31
 */
@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class SingleLoginRpcProviderImpl implements SingleLoginRpcProvider {

    private final NaturalSingleLoginService naturalSingleLoginService;

    private final SingleLoginService singleLoginService;

    private final TUserService tUserService;

    private final ConfigRpcProvider configRpcProvider;
    private final OrganizationRepository organizationRepository;

    private final TenantDbReader dbReader;

    public SingleLoginRpcProviderImpl(SingleLoginService singleLoginService,
                                      NaturalSingleLoginService naturalSingleLoginService,
                                      TUserService tUserService,
                                      OrganizationRepository organizationRepository,
                                      TenantDbReader dbReader,
                                      ConfigRpcProvider configRpcProvider) {
        this.singleLoginService = singleLoginService;
        this.naturalSingleLoginService = naturalSingleLoginService;
        this.tUserService = tUserService;
        this.organizationRepository = organizationRepository;
        this.configRpcProvider = configRpcProvider;
        this.dbReader = dbReader;
    }

    @Override
    public void checkAuth() throws Exception {
        if (!SSOConfig.getUseSwitch()) {
            throw new Exception("登录失败:非授权使用环境！");
        }
    }

    @Override
    public void saveLoginUser(String userName) throws Exception {
        if (!SSOConfig.getUseSwitch()) {
            throw new Exception("登录失败:非授权使用环境！");
        }
        if (!SSOConfig.getSelfAuth()) {
            SingleLoginUserDto singleLoginUserDto = singleLoginService.saveLoginUser(userName);
            List<String> employeeIds = new ArrayList<>();
            employeeIds.add(singleLoginUserDto.getEmployeeId());
            this.tUserService.dispatch(SyncUserRoleCommand.create(true, SSOConfig.getDomainId(), employeeIds, singleLoginUserDto.getRoleList()));
        }
    }

    @Override
    public String encryptByAES(String content) {
        return AES.encrypt(content, SSOConfig.getKey());
    }

    @Override
    public String saveLoginUserForNaturalPerson(String code) {
        SingleLoginUserDto singleLoginUserDto = naturalSingleLoginService.saveLoginUser(code);
        if(singleLoginUserDto.getRoleList() != null && singleLoginUserDto.getRoleList().size() > 0){
            List<String> employeeIds = new ArrayList<>();
            employeeIds.add(singleLoginUserDto.getEmployeeId());
            this.tUserService.dispatch(SyncUserRoleCommand.create(true, SSOConfig.getDomainId(), employeeIds, singleLoginUserDto.getRoleList()));
        }

        return singleLoginUserDto.getUserName();
    }

    @Override
    public String saveLoginUserForNaturalPerson(String certName,String certNo,String mobile) {
        SingleLoginUserDto singleLoginUserDto = naturalSingleLoginService.saveCommonLoginUser( certName, certNo, mobile);
        if(singleLoginUserDto.getRoleList() != null && singleLoginUserDto.getRoleList().size() > 0){
            List<String> employeeIds = new ArrayList<>();
            employeeIds.add(singleLoginUserDto.getEmployeeId());
            this.tUserService.dispatch(SyncUserRoleCommand.create(true, SSOConfig.getDomainId(), employeeIds, singleLoginUserDto.getRoleList()));
        }

        return singleLoginUserDto.getUserName();
    }

    /**
     * <b> 法人以自然人方式创建账号信息 </b>
     * @author ZXF
     * @create 2022/11/15 0015 14:21
     * @version
     * @注意事项 </b>
     */
    @Override
    public String saveLoginUserForLegalPerson(String certName,String certNo,String mobile) {
        SingleLoginUserDto singleLoginUserDto = naturalSingleLoginService.saveLegalLoginUser(certName,certNo,mobile);
        if(singleLoginUserDto.getRoleList() != null && singleLoginUserDto.getRoleList().size() > 0){
            List<String> employeeIds = new ArrayList<>();
            employeeIds.add(singleLoginUserDto.getEmployeeId());
            this.tUserService.dispatch(SyncUserRoleCommand.create(true, SSOConfig.getDomainId(), employeeIds, singleLoginUserDto.getRoleList()));
        }

        return singleLoginUserDto.getUserName();
    }

    @Override
    public String getRedirectUrlForNaturalPerson() throws UnsupportedEncodingException {
        return SSOConfig.getRedirectUrl()+ URLEncoder.encode(configRpcProvider.getValueByKey("v5WebUrl")+"/v3/identity/sso/login/naturalPerson","UTF-8");
    }

    @Override
    public LoginUserResponse findByIdNum(String idNum) {
        LoginUserDto loginUserDto = this.dbReader.getLoginUserByIdNum(idNum);
        return LoginUserResponse.create(loginUserDto.getId(),loginUserDto.getName(),loginUserDto.getTelephone());
    }

    @Override
    public XlcpLoginRequest getByEmployeeId(String organId, String employeeId) throws Exception {
        Optional<OrganizationEntity> organizationOptional = this.organizationRepository.findById(organId);
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException();
        }

        TenantUserCredentialsDto dto = this.dbReader.getCertificateByEmployeeId(employeeId);
        if(dto == null){
            throw new Exception("未检索到用户信息！");
        }

        OrganizationEntity organizationEntity = organizationOptional.get();
        XlcpLoginRequest loginRequest = new XlcpLoginRequest();
        loginRequest.setCompany_name(organizationEntity.getName());
        loginRequest.setCompany_id(organId);
        loginRequest.setName(dto.getName());
        loginRequest.setEmp_id(employeeId);
        loginRequest.setId_card(dto.getNumber());
        loginRequest.setAge(IdcardUtil.getAgeByIdCard(loginRequest.getId_card()));
        int gender =  IdcardUtil.getGenderByIdCard(loginRequest.getId_card())%2==0?2 : 1;

        loginRequest.setSex(gender);
        return loginRequest;
    }
}
