package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.enums.OrgRelationStatus;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.OrgRelationRpcProvider;
import com.bcxin.api.interfaces.tenants.responses.OrgRelationResponse;
import com.bcxin.tenant.domain.entities.OrgRelationEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.OrgRelationRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

/**
 * @author linqinglin
 * @date 2021/12/10 0010 14:46
 */

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000, methods = {
        @Method(name = "create",retries = 0,timeout = 10_000),
        @Method(name = "relieve",retries = 0,timeout = 10_000)
})
public class OrgRelationRpcProviderImpl implements OrgRelationRpcProvider {


    private final OrgRelationRepository orgRelationRepository;

    private final OrganizationRepository organizationRepository;

    public OrgRelationRpcProviderImpl(OrgRelationRepository orgRelationRepository,OrganizationRepository organizationRepository){
        this.orgRelationRepository = orgRelationRepository;
        this.organizationRepository = organizationRepository;
    }

    @Override
    public String create(String organizationId, String parentOrgId) {

        if(organizationId.equals(parentOrgId)){
            throw new NotAllowedTenantException("不能绑定自身为上级");
        }

        OrgRelationEntity checkRelation = orgRelationRepository.findByOrgId(organizationId, parentOrgId);
        if(checkRelation != null){
            throw new NotAllowedTenantException("已存在绑定关系");
        }

        Optional<OrganizationEntity> organizationEntity = organizationRepository.findById(organizationId);
        if(!organizationEntity.isPresent()){
            throw new NotFoundTenantException("当前组织信息错误");
        }
        Optional<OrganizationEntity> parentOrgEntity = organizationRepository.findById(parentOrgId);
        if(!parentOrgEntity.isPresent()){
            throw new NotFoundTenantException("上级组织信息错误");
        }


        OrgRelationEntity orgRelationEntity = OrgRelationEntity.create(organizationEntity.get(),parentOrgEntity.get());

        orgRelationRepository.save(orgRelationEntity);
        return orgRelationEntity.getId();
    }

    @Override
    public void relieve(String relationId) {
        Optional<OrgRelationEntity> relationEntity = orgRelationRepository.findById(relationId);
        if(relationEntity.isPresent()){
            OrgRelationEntity relation = relationEntity.get();
            relation.change(OrgRelationStatus.RELIEVE);
            orgRelationRepository.save(relation);
        }
    }

    @Override
    public List<OrgRelationResponse> getParentList(String organizationId) {
        Collection<OrgRelationDto> orgRelationList = orgRelationRepository.getParentList(organizationId);

        if(orgRelationList.size() > 0){
            List<OrgRelationResponse> responses = new ArrayList<>();
            OrgRelationResponse response = null;
            for (OrgRelationDto relationDto : orgRelationList) {
                response = OrgRelationResponse.create(relationDto.getRelationId(),relationDto.getOrgName(),relationDto.getUnifySocialCreditCode());
                responses.add(response);
            }
            return responses;
        }

        return null;
    }

    @Override
    public List<OrgRelationResponse> getChildrenList(String organizationId) {
        Collection<OrgRelationDto> orgRelationList = orgRelationRepository.getChildrenList(organizationId);

        if(orgRelationList.size() > 0){
            List<OrgRelationResponse> responses = new ArrayList<>();
            OrgRelationResponse response = null;
            for (OrgRelationDto relationDto : orgRelationList) {
                response = OrgRelationResponse.create(relationDto.getRelationId(),relationDto.getOrgName(),relationDto.getUnifySocialCreditCode());
                responses.add(response);
            }
            return responses;
        }

        return null;
    }
}
