package com.bcxin.tenant.apis.impls;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.OperateLogRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.operatelog.SearchOperateLogRequest;
import com.bcxin.api.interfaces.tenants.responses.OperateLogResponse;
import com.bcxin.tenant.domain.entities.OperateLogEntity;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.OperateLogRepository;
import com.bcxin.tenant.domain.repository.impls.EmployeeJpaRepository;
import com.bcxin.tenant.domain.repository.impls.OperateLogJpaRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.*;
import java.util.*;
import java.util.function.Function;

/**
 * description：操作日志表
 * author：linchunpeng
 * date：2023/12/13
 */
@Slf4j
@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class OperateLogRpcProviderImpl implements OperateLogRpcProvider {

    private final UnitWork unitWork;

    private final OperateLogJpaRepository operateLogJpaRepository;

    private final TenantDbReader dbReader;

    public OperateLogRpcProviderImpl(UnitWork unitWork,
                                     OperateLogJpaRepository operateLogJpaRepository,
                                     TenantDbReader dbReader){
        this.unitWork = unitWork;
        this.operateLogJpaRepository = operateLogJpaRepository;
        this.dbReader = dbReader;
    }

    /**
     * description：记录登录日志
     * author：linchunpeng
     * date：2023/12/13
     */
    @Override
    public void loginLog(String tenantUserId, String userName, String realName, String ipAddress) {
        this.logOperate(tenantUserId, userName, realName, 1, "登录组织", "登录成功", ipAddress);
    }

    /**
     * description：记录登出日志
     * author：linchunpeng
     * date：2023/12/13
     */
    @Override
    public void logoutLog(String tenantUserId, String userName, String ipAddress) {
//        this.logOperate(tenantUserId, userName, 2, ipAddress);
    }

    /**
     * description：记录操作日志
     * author：linchunpeng
     * date：2023/12/13
     */
    private void logOperate(String tenantUserId, String userName, String realName, Integer operateType, String operateContent,
                            String operateResult, String ipAddress) {
        try {
            log.info("记录操作日志，参数：tenantUserId：{}， userName：{}， operateType：{}， ipAddress：{}", tenantUserId, userName, operateType, ipAddress);
            this.unitWork.executeTran(() -> {
                        OperateLogEntity operateLogEntity = new OperateLogEntity();
                        operateLogEntity.setTenantUserId(tenantUserId);
                        operateLogEntity.setUserName(userName);
                        operateLogEntity.setRealName(realName);
                        operateLogEntity.setOperateType(operateType);
                        operateLogEntity.setOperateContent(operateContent);
                        operateLogEntity.setOperateResult(operateResult);
                        operateLogEntity.setIpAddress(ipAddress);
                        operateLogEntity.setOperateTime(new Date());
                        this.operateLogJpaRepository.save(operateLogEntity);
                    });
        } catch (Exception e) {
            log.error("记录操作日志异常：{}", e.getMessage(), e);
        }
    }

    /**
     * description：分页查询操作日志
     * author：linchunpeng
     * date：2023/12/14
     */
    @Override
    public Pageable<OperateLogResponse> getList(SearchOperateLogRequest request, String orgId) {
        return dbReader.getOperateLogList(request, orgId);
    }
}
