package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.InviteAttendSiteRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.inviteAttendSite.InviteAttendSiteRequest;
import com.bcxin.api.interfaces.tenants.responses.InviteAttendSiteResponse;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.InviteAttendSiteEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.InviteAttendSiteRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;

import java.util.Date;
import java.util.Optional;

/**
 * @author linqinglin
 * @date 2021/12/08 0008 16:49
 */

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120 *1000, methods = {
        @Method(name = "create",retries = 0,timeout = 10 *1000)
})
public class InviteAttendSiteRpcProviderImpl implements InviteAttendSiteRpcProvider {


    private final InviteAttendSiteRepository inviteAttendSiteRepository;

    private final OrganizationRepository organizationRepository;

    private final DepartmentRepository departmentRepository;

    public InviteAttendSiteRpcProviderImpl(InviteAttendSiteRepository inviteAttendSiteRepository, OrganizationRepository organizationRepository, DepartmentRepository departmentRepository){
        this.inviteAttendSiteRepository = inviteAttendSiteRepository;
        this.organizationRepository = organizationRepository;
        this.departmentRepository = departmentRepository;
    }

    @Override
    public InviteAttendSiteResponse getUnOvertime(String id) {
        Optional<InviteAttendSiteEntity> inviteDepartOptional = inviteAttendSiteRepository.findById(id);
        if(!inviteDepartOptional.isPresent()){
            return null;
        }

        InviteAttendSiteEntity inviteAttendSite = inviteDepartOptional.get();

        if(inviteAttendSite.getEndTime().before(DateUtil.fromString(DateUtil.format2ShortDate(new Date())))){
            return null;
        }

        InviteAttendSiteResponse response = new InviteAttendSiteResponse();
        response.setId(inviteAttendSite.getId());

        response.setAttendSiteId(inviteAttendSite.getAttendSiteId());
        response.setAttendSiteName(inviteAttendSite.getAttendSiteName());

        response.setDepartId(inviteAttendSite.getDepartment().getId());
        response.setDepartName(inviteAttendSite.getDepartment().getName());
        response.setOrganizationId(inviteAttendSite.getOrganization().getId());
        response.setOrganizationName(inviteAttendSite.getOrganization().getName());
        response.setOccupationType(inviteAttendSite.getOccupationType());
        response.setEndTime(inviteAttendSite.getEndTime());
        response.setAreaCode(inviteAttendSite.getAreaCode());
        response.setCreator(inviteAttendSite.getCreator());
        return response;
    }

    @Override
    public String create(String organizationId, InviteAttendSiteRequest request) {
        Optional<OrganizationEntity> organization = organizationRepository.findById(organizationId);
        Optional<DepartmentEntity> department = departmentRepository.findById(request.getDepartId());
        if(!department.isPresent() || department.get().isDeleted()) {
            throw new NotFoundTenantException("该部门信息无效");
        }

        InviteAttendSiteEntity inviteAttendSiteEntity = InviteAttendSiteEntity.create(request.getAttendSiteId(),
                request.getAttendSiteName(),
                organization.get(),
                department.get(),
                request.getOccupationType(),
                request.getEndTime(),
                AuthUtil.getAreaCode(),
                AuthUtil.getCurrentOperator());
        inviteAttendSiteRepository.save(inviteAttendSiteEntity);
        return inviteAttendSiteEntity.getId();
    }
}
