package com.bcxin.tenant.apis.eventHandlers;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.api.interfaces.backends.BackendRpfProvider;
import com.bcxin.api.interfaces.backends.requests.EventSubscriberRequest;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.TenantUserAfterCreatedEvent;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Executors;

/**
 * 新增租户用户->发送下载app短信
 */
@Slf4j
@Component
public class TenantUserAfterCreatedEvent_Handler extends DomainEventHandlerAbstract<TenantUserAfterCreatedEvent> {
    private final BackendRpfProvider backendRpfProvider;

    public TenantUserAfterCreatedEvent_Handler(BackendRpfProvider backendRpfProvider) {
        this.backendRpfProvider = backendRpfProvider;
    }

    @Override
    protected void execute(TenantUserAfterCreatedEvent event) {
        Collection<String> selectors = new ArrayList<>();
        selectors.add(EventAction.TenantUserAfterCreatedEventForIdentity.name());
        selectors.add(EventAction.TenantUserAfterCreatedEventForSms.name());
        Executors.newSingleThreadExecutor().execute(() -> {
            StringBuilder track = new StringBuilder();
            try {
                track.append(String.format("跟进执行TenantUserAfterCreatedEvent_Handler.execute=%s;", event.getData().getId()));
                this.backendRpfProvider.dispatch(EventSubscriberRequest.create(selectors, event.getData().getId()));
                track.append("执行完毕");
            } catch (Exception ex) {
                track.append(ExceptionUtil.getStackMessage(ex));
            }
        });
    }
}
