package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class TocUserAssignIdentityCommand extends CommandAbstract {
    private final String tenantUserId;

    private final String name;

    private final String phone;

    private final String number;
    private final String openId;

    private final String unionId;

    public TocUserAssignIdentityCommand(String tenantUserId, String openId, String unionId,String name,String number,String phone) {
        this.tenantUserId = tenantUserId;
        this.openId = openId;
        this.unionId = unionId;

        this.name = name;
        this.number = number;
        this.phone = phone;
    }

    public static TocUserAssignIdentityCommand create(String tenantUserId, String openId, String unionId,String name,String number,String phone) {
        return new TocUserAssignIdentityCommand(tenantUserId, openId, unionId, name, number, phone);
    }
}
