package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class SignUpCommand extends CommandAbstract {
    private final String telephone;
    private final String idNum;
    private final String name;
    private final String tenantUserId;
    private final Collection<CredentialCommandItem> credentials;

    public SignUpCommand(String tenantUserId, String telephone,String idNum, String name,Collection<CredentialCommandItem> credentials) {
        this.telephone = telephone;
        this.idNum = idNum;
        this.name = name;
        this.tenantUserId = tenantUserId;
        this.credentials = credentials;
    }

    public static SignUpCommand create(String tenantUserId,String telephone, String idNum, String name,Collection<CredentialCommandItem> credentials) {
        return new SignUpCommand(tenantUserId, telephone,idNum, name,credentials);
    }

    @Getter
    public static class CredentialCommandItem {
        private final CredentialType credentialType;

        private final String number;

        public CredentialCommandItem(CredentialType credentialType, String number) {
            this.credentialType = credentialType;
            this.number = number;

        }

        public static CredentialCommandItem create(CredentialType credentialType, String number) {
            return new CredentialCommandItem(credentialType, number);
        }
    }
}
