package com.bcxin.identity.domains.services;

import com.bcxin.identity.domains.entities.UserNamePasswordPrincipalEntity;
import com.bcxin.identity.domains.services.commandResult.PrepareResetPasswordCommandResult;
import com.bcxin.identity.domains.services.commandResult.WechatCgiBinSignInCommandResult;
import com.bcxin.identity.domains.services.commands.*;

public interface IdentityUserService {
    SignInCommand.SignInCommandResult signIn(SignInCommand command);

    /**
     * description：登录失败增加计数
     * author：linchunpeng
     * date：2025/3/31
     */
    int loginFailAddCount(UserNamePasswordPrincipalEntity principal);

    /**
     * description：登录成功，清除登录失败计数
     * author：linchunpeng
     * date：2025/3/31
     */
    void loginFailClearCount(UserNamePasswordPrincipalEntity principal);

    ChangePasswordCommand.ChangePasswordCommandResult changePassword(ChangePasswordCommand command);

    void signUp(SignUpCommand command);

    void dispatch(WechatBindCommand command);

    SignInCommand.SignInCommandResult dispatch(WechatSignInCommand command);

    void dispatch(UpdateIdentityBasicCommand command);

    void dispatch(WechatUnBindCommand command);

    /**
     * description：判断是否绑定微信unionid
     * author：linchunpeng
     * date：2023/10/12
     */
    boolean dispatch(WechatCheckUnionIdCommand command);

    PrepareResetPasswordCommandResult dispatch(PrepareResetPasswordCommand command);

    void dispatch(ResetPasswordCommand command);

    PrepareResetPasswordCommandResult getUserMobile(PrepareResetPasswordCommand command);

    void dispatch(ResetPasswordCommandAdmin command);

    void resetPasswordCheckCode(ResetPasswordCommand command);

    void changeUserName(ChangeUserNameCommand command);

    WechatCgiBinSignInCommandResult dispatch(WechatCgiBinSignInCommand command);

    void dispatch(TocUserAssignIdentityCommand command);
}
