/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.PersonStatus;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.api.interfaces.ResponseAbstract;
import com.bcxin.api.interfaces.tenants.responses.DepartResponse;
import com.bcxin.api.interfaces.tenants.responses.UserDetailGetResponse;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;

public class EmployeeDetailGetResponse
extends ResponseAbstract {
    @ApiModelProperty(value="Id")
    private final String id;
    @ApiModelProperty(value="\u90e8\u95e8Id")
    private final String departId;
    @ApiModelProperty(value="\u90e8\u95e8\u540d\u79f0")
    private final String departName;
    @ApiModelProperty(value="\u4e0a\u7ea7Id")
    private final String superiorId;
    @ApiModelProperty(value="\u4e0a\u7ea7\u540d\u79f0")
    private final String superiorName;
    @ApiModelProperty(value="\u5165\u804c\u65f6\u95f4")
    private final String hiredDate;
    @ApiModelProperty(value="\u8f6c\u6b63\u65f6\u95f4")
    private final String positiveDate;
    @ApiModelProperty(value="\u804c\u4f4d")
    private final String position;
    @ApiModelProperty(value="\u804c\u4e1a\u7c7b\u578b")
    private final OccupationType occupationType;
    private final TrueFalseStatus isInsure;
    private final UserDetailGetResponse userInfo;
    private final long workDays;
    private final List<DepartResponse> departs;
    @ApiModelProperty(value="\u9762\u8c08\u8bb0\u5f55")
    private String interview;
    @ApiModelProperty(value="\u5458\u5de5\u72b6\u6001")
    private final PersonStatus personStatus;
    @ApiModelProperty(value="\u8bd5\u7528\u671f")
    private final String probation;
    @ApiModelProperty(value="\u539f\u5b9a\u8f6c\u6b63\u65e5\u671f")
    private final Date planPositiveDate;
    @ApiModelProperty(value="\u85aa\u8d44")
    private String salary;

    public EmployeeDetailGetResponse(String id, String departId, String departName, String superiorId, String superiorName, Date hiredDate, Date positiveDate, String position, OccupationType occupationType, TrueFalseStatus isInsure, UserDetailGetResponse userInfo, List<DepartResponse> departs, String interview, PersonStatus personStatus, String probation, Date planPositiveDate, String salary) {
        this.id = id;
        this.superiorId = superiorId;
        this.superiorName = superiorName;
        this.isInsure = isInsure;
        this.departs = departs;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (hiredDate != null) {
            this.hiredDate = simpleDateFormat.format(hiredDate);
            this.workDays = DateUtil.between((Date)hiredDate, (Date)Timestamp.from(Instant.now()), (DateUnit)DateUnit.DAY);
        } else {
            this.hiredDate = null;
            this.workDays = 0L;
        }
        this.positiveDate = positiveDate != null ? simpleDateFormat.format(positiveDate) : null;
        this.position = position;
        this.occupationType = occupationType;
        this.userInfo = userInfo;
        this.departId = departId;
        this.departName = departName;
        this.interview = CdnUtils.convert((String)interview);
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.salary = salary;
    }

    public static EmployeeDetailGetResponse create(String id, String departId, String departName, String superiorId, String superiorName, Date hiredDate, Date positiveDate, String position, OccupationType occupationType, TrueFalseStatus isInsure, UserDetailGetResponse userInfo, List<DepartResponse> departs, String interview, PersonStatus personStatus, String probation, Date planPositiveDate, String salary) {
        return new EmployeeDetailGetResponse(id, departId, departName, superiorId, superiorName, hiredDate, positiveDate, position, occupationType, isInsure, userInfo, departs, interview, personStatus, probation, planPositiveDate, salary);
    }

    public String getId() {
        return this.id;
    }

    public String getDepartId() {
        return this.departId;
    }

    public String getDepartName() {
        return this.departName;
    }

    public String getSuperiorId() {
        return this.superiorId;
    }

    public String getSuperiorName() {
        return this.superiorName;
    }

    public String getHiredDate() {
        return this.hiredDate;
    }

    public String getPositiveDate() {
        return this.positiveDate;
    }

    public String getPosition() {
        return this.position;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public TrueFalseStatus getIsInsure() {
        return this.isInsure;
    }

    public UserDetailGetResponse getUserInfo() {
        return this.userInfo;
    }

    public long getWorkDays() {
        return this.workDays;
    }

    public List<DepartResponse> getDeparts() {
        return this.departs;
    }

    public String getInterview() {
        return this.interview;
    }

    public PersonStatus getPersonStatus() {
        return this.personStatus;
    }

    public String getProbation() {
        return this.probation;
    }

    public Date getPlanPositiveDate() {
        return this.planPositiveDate;
    }

    public String getSalary() {
        return this.salary;
    }
}

