package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.validations.TelephoneValidator;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class UpdateBasicTenantUserCommand extends CommandAbstract {
    private final String id;
    private final String name;
    private final String telephone;

    public UpdateBasicTenantUserCommand(String id, String name, String telephone) {
        this.name = name;
        this.telephone = telephone;
        this.id = id;
    }

    public static UpdateBasicTenantUserCommand create(String id, String name, String telephone) {
        return new UpdateBasicTenantUserCommand(id, name, telephone);
    }

    public void validate(boolean isRequiredPhoneAsLoginName) {
        if (!StringUtils.hasLength(this.getId())) {
            throw new ArgumentTenantException("Id不能为空");
        }

        if (!StringUtils.hasLength(this.getName())) {
            throw new ArgumentTenantException("姓名不能为空");
        }

        if (isRequiredPhoneAsLoginName) {
            if (!StringUtils.hasLength(this.getTelephone())) {
                throw new ArgumentTenantException("账号不能为空");
            }
            if (this.getTelephone() != null && this.getTelephone().length() > 30) {
                throw new ArgumentTenantException("账号长度不能超过三十位");
            }
        } else {
            if (!StringUtils.hasLength(this.getTelephone())) {
                throw new ArgumentTenantException("手机不能为空");
            }

            if (!TelephoneValidator.checkIsValid(this.getTelephone())) {
                throw new ArgumentTenantException("手机格式不正确");
            }
        }
    }
}
