package com.bcxin.tenant.domain.services.commands.results;

import com.bcxin.tenant.domain.snapshots.EmployeeImportedResultSnapshot;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

@Getter
public class BatchImportEmployeeCommandResult {
    private final String downloadResourceId;
    private final EmployeeImportedResultSnapshot result;

    @JsonIgnore
    public int getTotalSuccess() {
        if(CollectionUtils.isEmpty(result.getResult())) {
            return 0;
        }

        return (int)result.getResult().stream().filter(ii -> ii.getIsSuccess()).count();
    }

    @JsonIgnore
    public int getTotalFailed()
    {
        if(CollectionUtils.isEmpty(result.getResult())) {
            return 0;
        }
        return (int)result.getResult().stream().filter(ii -> !ii.getIsSuccess()).count();
    }

    public BatchImportEmployeeCommandResult(String downloadResourceId, EmployeeImportedResultSnapshot result) {
        this.downloadResourceId = downloadResourceId;
        this.result = result;
    }

    public static BatchImportEmployeeCommandResult create(String downloadResourceId, EmployeeImportedResultSnapshot result) {
        return new BatchImportEmployeeCommandResult(downloadResourceId, result);
    }
}
