package com.bcxin.tenant.domain.services.commands.organizations;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.*;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyUpdateRequest;
import lombok.Getter;

import java.util.Date;
import java.util.List;

@Getter
public class UpdateCompanyCommand extends CommandAbstract {

    private String id;

    /**
     * 系统名称
     */
    private final String sysName;

    private final String logoPath;

    /**
     * 描述
     */
    private final String description;
    /**
     * 经度
     */
    private final Double longitude;
    /**
     * 纬度
     */
    private final Double latitude;

    private final String locationAddress;

    //机构类型
    private final String institutionalCode;

    //保安服务公司类型（机构类型 = 保安服务公司 必填）
    private final IndustryDetailType industryDetailType;


    //基本信息
    //公司名称
    private final String name;

    //总/分/子公司
    private final ParentSubsidiary type;

    //联系电话
    private final String telephone;

    //经济类型
    private final EconomicType economicType;

    //公司类型
    private final CompanyNature nature;

    //注册地区
    private final LocationCommandItem placeOfRegister;

    //经营地区
    private final LocationCommandItem placeOfBusiness;


    //总公司信息，保安行业必填
    //总公司名称（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）
    private final String parentName;

    //总公司证件类型（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）
    private final CompanyCertificateType parentCertificateType;

    //总公司证件号码（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）
    private final String parentCertificateNumber;

    //总公司法人姓名（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）
    private final String parentLegalPersonName;

    //总公司联系电话（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）
    private final String parentLegalPersonTelephone;

    //法人或负责人信息
    private final String legalPersonName;

    //法人手机号码
    private final String legalPersonTelephone;

    //法人证件类型
    private final CredentialType legalPersonCredentialType;

    //法人证件号码
    private final String legalPersonCredentialNumber;

    //法人国籍
    private final String legalPersonNationality;

    //保安负责人信息
    //保安负责人姓名
    private final String securityPersonName;

    //保安负责人手机号码
    private final String securityPersonTelephone;

    //保安负责人证件类型
    private final CredentialType securityPersonCredentialType;

    //保安负责人证件号码
    private final String securityPersonCredentialNumber;

    //注册信息
    //注册资本（万元）
    private final String registeredCapital;

    //固定资本（万元，机构类型 = 保安服务公司 必填）
    private final String fixedCapital;

    //年营业额（万元，机构类型 = 保安服务公司 必填）
    private final String annualSalesVolume;

    //年利税（万元，机构类型 = 保安服务公司 必填）
    private final String annualProfitTax;

    //证件类型", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType
    private final CompanyCertificateType certificateType;

    //统一社会信用代码
    private final String unifySocialCreditCode;

    //营业执照附件
    private final String unifySocialCreditCodeFile;


    //资质信息
    //保安服务许可/保安培训备案证号（机构类型 = 保安服务公司 || 保安培训单位 必填）
    private final String servicePermitNumber;

    //发证机关名称（机构类型 = 保安服务公司 || 保安培训单位 必填）
    private final String nameOfIssuingAuthority;

    //保安服务许可证首次发证日期或者培训单位的发证日期（机构类型 = 保安服务公司 || 保安培训单位 必填）
    private final Date firstIssueServicePermit;

    //保安服务许可证扫描件或者保安培训许可（备案）证扫描件（机构类型 = 保安服务公司 || 保安培训单位 必填）
    private final String servicePermitAttachment;


    //批准文号（机构类型 = 保安服务公司 必填）
    private final String securityApprovalNumber;

    //服务范围（机构类型 = 保安服务公司 必填）
    private final List<String> serviceScopeList;

    //人力防范评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecurityPreparednessRating
    private final SecurityPreparednessRating securityPreparednessRating;

    //武装守护押运评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecurityArmedRating
    private final SecurityArmedRating securityArmedRating;

    //安全技术防范评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating
    private final SecuritySafetyDefenseRating securitySafetyDefenseRating;

    //是否有风险评估资质（机构类型 = 保安服务公司 必填）
    private final Boolean isRiskAssessment;


    //培训单位的培训内容（机构类型 = 保安培训单位 必填）
    private final String trainContent;


    //自行招用保安员单位
    //拟自招保安员数（机构类型 = 自行招用保安员单位 必填）
    private final Integer numberOfSecurityGuards;

    //是否治安保卫重点单位（机构类型 = 自行招用保安员单位 必填）
    private final Boolean isPublicSecuritySecurity;

    //是否物业企业（机构类型 = 自行招用保安员单位 必填）
    private final Boolean isPropertyEnterprise;

    //自招保安单位性质（机构类型 = 自行招用保安员单位 必填）
    private final String natureOfSelfRecruitedUnits;


    //监管归属
    //监管地区
    private final String placeOfSupervise;

    //监管机构
    private final String superviseDepartId;

    //监管机构名称
    private final String superviseDepartName;

    //传真
    private final String fax;

    //传真
    private final String adminUserName;

    //传真
    private final String adminUserTelephone;

    public UpdateCompanyCommand(String id, String sysName, String logoPath, String description, Double longitude, Double latitude,
                                String institutionalCode, IndustryDetailType industryDetailType,
                                String name, ParentSubsidiary type, String telephone, EconomicType economicType,
                                CompanyNature nature, LocationCommandItem placeOfRegister, LocationCommandItem placeOfBusiness,
                                String parentName, CompanyCertificateType parentCertificateType, String parentCertificateNumber,
                                String parentLegalPersonName, String parentLegalPersonTelephone,
                                String legalPersonName, String legalPersonTelephone, CredentialType legalPersonCredentialType,
                                String legalPersonCredentialNumber, String legalPersonNationality, String securityPersonName, String securityPersonTelephone,
                                CredentialType securityPersonCredentialType, String securityPersonCredentialNumber,
                                String registeredCapital, String fixedCapital,
                                String annualSalesVolume, String annualProfitTax, CompanyCertificateType certificateType,
                                String unifySocialCreditCode, String unifySocialCreditCodeFile, String servicePermitNumber,
                                String nameOfIssuingAuthority, Date firstIssueServicePermit, String servicePermitAttachment,
                                String securityApprovalNumber, List<String> serviceScopeList, SecurityPreparednessRating securityPreparednessRating,
                                SecurityArmedRating securityArmedRating, SecuritySafetyDefenseRating securitySafetyDefenseRating,
                                Boolean isRiskAssessment, String trainContent, Integer numberOfSecurityGuards,
                                Boolean isPublicSecuritySecurity, Boolean isPropertyEnterprise, String natureOfSelfRecruitedUnits,
                                String placeOfSupervise, String superviseDepartId, String superviseDepartName, String fax, CompanyUpdateRequest.ContactRequest administrator,
                                String locationAddress) {
        this.id = id;
        this.sysName = sysName;
        this.logoPath = logoPath;
        this.description = description;
        this.longitude = longitude;
        this.latitude = latitude;

        this.institutionalCode = institutionalCode;
        this.industryDetailType = industryDetailType;
        this.name = name;
        this.type = type;
        this.telephone = telephone;
        this.economicType = economicType;
        this.nature = nature;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.parentName = parentName;
        this.parentCertificateType = parentCertificateType;
        this.parentCertificateNumber = parentCertificateNumber;
        this.parentLegalPersonName = parentLegalPersonName;
        this.parentLegalPersonTelephone = parentLegalPersonTelephone;
        this.legalPersonName = legalPersonName;
        this.legalPersonTelephone = legalPersonTelephone;
        this.legalPersonCredentialType = legalPersonCredentialType;
        this.legalPersonCredentialNumber = legalPersonCredentialNumber;
        this.legalPersonNationality = legalPersonNationality;
        this.securityPersonName = securityPersonName;
        this.securityPersonTelephone = securityPersonTelephone;
        this.securityPersonCredentialType = securityPersonCredentialType;
        this.securityPersonCredentialNumber = securityPersonCredentialNumber;
        this.registeredCapital = registeredCapital;
        this.fixedCapital = fixedCapital;
        this.annualSalesVolume = annualSalesVolume;
        this.annualProfitTax = annualProfitTax;
        this.certificateType = certificateType;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.servicePermitNumber = servicePermitNumber;
        this.nameOfIssuingAuthority = nameOfIssuingAuthority;
        this.firstIssueServicePermit = firstIssueServicePermit;
        this.servicePermitAttachment = servicePermitAttachment;
        this.securityApprovalNumber = securityApprovalNumber;
        this.serviceScopeList = serviceScopeList;
        this.securityPreparednessRating = securityPreparednessRating;
        this.securityArmedRating = securityArmedRating;
        this.securitySafetyDefenseRating = securitySafetyDefenseRating;
        this.isRiskAssessment = isRiskAssessment;
        this.trainContent = trainContent;
        this.numberOfSecurityGuards = numberOfSecurityGuards;
        this.isPublicSecuritySecurity = isPublicSecuritySecurity;
        this.isPropertyEnterprise = isPropertyEnterprise;
        this.natureOfSelfRecruitedUnits = natureOfSelfRecruitedUnits;
        this.placeOfSupervise = placeOfSupervise;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.fax = fax;
        if (administrator != null) {
            this.adminUserName = administrator.getName();
            this.adminUserTelephone = administrator.getTelephone();
        } else {
            this.adminUserName = null;
            this.adminUserTelephone = null;
        }
        this.locationAddress = locationAddress;
    }



    public static UpdateCompanyCommand create(String id,
                                              String sysName,
                                              String logoPath,
                                              String description,
                                              Double longitude,
                                              Double latitude,
                                              CompanyUpdateRequest request) {
        return new UpdateCompanyCommand(id, sysName, logoPath, description, longitude, latitude, request.getInstitutionalCode(), request.getIndustryDetailType(),
                request.getName(), request.getType(), request.getTelephone(), request.getEconomicType(),
                request.getNature(), LocationCommandItem.create(request.getPlaceOfRegister()), LocationCommandItem.create(request.getPlaceOfBusiness()),
                request.getParentName(), request.getParentCertificateType(), request.getParentCertificateNumber(),
                request.getParentLegalPersonName(), request.getParentLegalPersonTelephone(),
                request.getLegalPersonName(), request.getLegalPersonTelephone(), request.getLegalPersonCredentialType(),
                request.getLegalPersonCredentialNumber(), request.getLegalPersonNationality(), request.getSecurityPersonName(),
                request.getSecurityPersonTelephone(), request.getSecurityPersonCredentialType(), request.getSecurityPersonCredentialNumber(),
                request.getRegisteredCapital(), request.getFixedCapital(),
                request.getAnnualSalesVolume(), request.getAnnualProfitTax(), request.getCertificateType(),
                request.getUnifySocialCreditCode(), request.getUnifySocialCreditCodeFile(), request.getServicePermitNumber(),
                request.getNameOfIssuingAuthority(), request.getFirstIssueServicePermit(), request.getServicePermitAttachment(),
                request.getSecurityApprovalNumber(), request.getServiceScopeList(), request.getSecurityPreparednessRating(),
                request.getSecurityArmedRating(), request.getSecuritySafetyDefenseRating(),
                request.getIsRiskAssessment(), request.getTrainContent(), request.getNumberOfSecurityGuards(),
                request.getIsPublicSecuritySecurity(), request.getIsPropertyEnterprise(), request.getNatureOfSelfRecruitedUnits(),
                request.getPlaceOfSupervise(), request.getSuperviseDepartId(), request.getSuperviseDepartName(), request.getFax(), request.getAdministrator(),
                request.getLocationAddress());
    }

}
