package com.bcxin.tenant.domain.services.commands.organizationAdmins;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class CreateOrganizationAdminCommand extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> employeeIds;

    public CreateOrganizationAdminCommand(String organizationId, Collection<String>  employeeIds) {
        this.organizationId = organizationId;
        this.employeeIds = employeeIds;
    }

    public static CreateOrganizationAdminCommand create(String organizationId, Collection<String> employeeIds) {
        return new CreateOrganizationAdminCommand(organizationId, employeeIds);
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new ArgumentTenantException("组织Id不能为空");
        }

        if (CollectionUtils.isEmpty(this.getEmployeeIds())) {
            throw new ArgumentTenantException("职员Id不能为空");
        }
    }
}
