package com.bcxin.tenant.domain.services.commands;

import com.bcxin.tenant.domain.snapshots.DepartmentImportedItemSnapshot;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class ImportDepartmentCommand {
    private final String organizationId;
    private final String path;
    private final Collection<DepartmentImportedItemSnapshot> items;

    public ImportDepartmentCommand(String path,
                                   String organizationId,
                                   Collection<DepartmentImportedItemSnapshot> items) {
        this.organizationId = organizationId;
        this.path = path;
        this.items = items;
    }

    @Getter
    public static class DepartmentCommandItem {
        private final String name;
        private final String displayOrder;
        private final String parentTreeName;
        private final String permissionType;
        private final int paramIndex;

        public DepartmentCommandItem(
                int paramIndex,
                String name,
                String displayOrder,
                String parentTreeName,
                String permissionType) {
            this.paramIndex = paramIndex;
            this.name = name;
            this.displayOrder = displayOrder;
            this.parentTreeName = parentTreeName;
            this.permissionType = permissionType;
        }

        public int getTreeDepth() {
            if (!StringUtils.hasLength(this.getParentTreeName())) {
                return 0;
            }

            return this.getParentTreeName().split("/").length;
        }

        public static DepartmentCommandItem create(int paramIndex, String name,
                                                   String displayOrder,
                                                   String parentTreeName,
                                                   String permissionType) {
            return new DepartmentCommandItem(paramIndex, name, displayOrder, parentTreeName, permissionType);
        }
    }

    public static ImportDepartmentCommand create(String path, String organizationId,
                                                 Collection<DepartmentImportedItemSnapshot> items) {
        return new ImportDepartmentCommand(path, organizationId, items);
    }
}
