package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.domain.enums.EventAction;
import lombok.Getter;

@Getter
public class CreateTenantEventCommand extends CommandAbstract {
    private final EventAction eventAction;
    private final String content;
    private final String keyword;

    public CreateTenantEventCommand(EventAction eventAction, String content, String keyword) {
        this.eventAction = eventAction;
        this.content = content;
        this.keyword = keyword;
    }

    public static CreateTenantEventCommand create(EventAction eventAction, String content, String keyword) {
        return new CreateTenantEventCommand(eventAction, content, keyword);
    }
}
